% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concordia.R
\name{concordia}
\alias{concordia}
\title{Concordia diagram}
\usage{
concordia(
  x = NULL,
  tlim = NULL,
  alpha = 0.05,
  type = 1,
  show.numbers = FALSE,
  levels = NA,
  clabel = "",
  ellipse.fill = c("#00FF0080", "#FF000080"),
  ellipse.stroke = "black",
  concordia.col = "darksalmon",
  exterr = FALSE,
  show.age = 0,
  sigdig = 2,
  common.Pb = 0,
  ticks = 5,
  anchor = 0,
  hide = NULL,
  omit = NULL,
  omit.fill = NA,
  omit.stroke = "grey",
  ...
)
}
\arguments{
\item{x}{an object of class \code{UPb}}

\item{tlim}{age limits of the concordia line}

\item{alpha}{probability cutoff for the error ellipses and
confidence intervals}

\item{type}{one of

\code{1}: Wetherill -- \eqn{{}^{206}}Pb/\eqn{{}^{238}}U
vs. \eqn{{}^{207}}Pb/\eqn{{}^{235}}U

\code{2}: Tera-Wasserburg -- \eqn{{}^{207}}Pb/\eqn{{}^{206}}Pb
vs. \eqn{{}^{238}}U/\eqn{{}^{206}}Pb

\code{3}: U-Th-Pb concordia -- \eqn{{}^{208}}Pb/\eqn{{}^{232}}Th
vs. \eqn{{}^{206}}Pb/\eqn{{}^{238}}U (only available if
\code{x$format=7} or \code{8})}

\item{show.numbers}{logical flag (\code{TRUE} to show grain
numbers)}

\item{levels}{a vector with \code{length(x)} values to be displayed
as different background colours within the error ellipses.}

\item{clabel}{label for the colour legend (only used if
\code{levels} is not \code{NA}).}

\item{ellipse.fill}{Fill colour for the error ellipses. This can either be a single
colour or multiple colours to form a colour ramp. Examples:

a single colour: \code{rgb(0,1,0,0.5)}, \code{'#FF000080'},
\code{'white'}, etc.;

multiple colours: \code{c(rbg(1,0,0,0.5)},
\code{rgb(0,1,0,0.5))}, \code{c('#FF000080','#00FF0080')},
\code{c('blue','red')}, \code{c('blue','yellow','red')}, etc.;

a colour palette: \code{rainbow(n=100)},
\code{topo.colors(n=100,alpha=0.5)}, etc.; or

a reversed palette: \code{rev(topo.colors(n=100,alpha=0.5))},
etc.

For empty ellipses, set \code{ellipse.fill=NA}}

\item{ellipse.stroke}{the stroke colour for the error
ellipses. Follows the same formatting guidelines as
\code{ellipse.fill}}

\item{concordia.col}{colour of the concordia line}

\item{exterr}{show decay constant uncertainties?}

\item{show.age}{one of either:

\code{0}: plot the data without calculating an age

\code{1}: fit a concordia composition and age

\code{2}: fit a discordia line through the data using the maximum
likelihood algorithm of Ludwig (1998), which assumes that the
scatter of the data is solely due to the analytical
uncertainties. In this case, \code{IsoplotR} will either calculate
an upper and lower intercept age (for Wetherill concordia), or a
lower intercept age and common
(\eqn{^{207}}Pb/\eqn{^{206}}Pb)-ratio intercept (for
Tera-Wasserburg). If \code{mswd}>0, then the analytical
uncertainties are augmented by a factor \eqn{\sqrt{mswd}}.

\code{3}: fit a discordia line ignoring the analytical uncertainties

\code{4}: fit a discordia line using a modified maximum likelihood
algorithm that includes accounts for any overdispersion by adding a
geological (co)variance term.}

\item{sigdig}{number of significant digits for the
concordia/discordia age}

\item{common.Pb}{common lead correction:

\code{0}:none

\code{1}: use the Pb-composition stored in

\code{settings('iratio','Pb207Pb206')} (if \code{x$format<4});

\code{settings('iratio','Pb206Pb204')} and
\code{settings('iratio','Pb207Pb204')} (if \code{3<x$format<7}); or

\code{settings('iratio','Pb208Pb206')} and
\code{settings('iratio','Pb208Pb207')} (if \code{x$format>6}).

\code{2}: use the isochron intercept as the initial Pb-composition

\code{3}: use the Stacey-Kramers two-stage model to infer the initial
Pb-composition.}

\item{ticks}{either a scalar indicating the desired number of age
ticks to be placed along the concordia line, OR a vector of
tick ages.}

\item{anchor}{control parameters to fix the intercept age or common Pb
composition of the isochron fit. This can be a scalar or a vector.

If \code{anchor[1]=0}: do not anchor the isochron.

If \code{anchor[1]=1}: fix the common Pb composition at the values
stored in \code{settings('iratio',...)}.

If \code{anchor[1]=2}: force the isochron line to intersect the
concordia line at an age equal to \code{anchor[2]}.}

\item{hide}{vector with indices of aliquots that should be removed
from the concordia diagram}

\item{omit}{vector with indices of aliquots that should be plotted
but omitted from concordia or discordia age calculation}

\item{omit.fill}{fill colour that should be used for the omitted
aliquots.}

\item{omit.stroke}{stroke colour that should be used for the
omitted aliquots.}

\item{...}{optional arguments to the generic \code{plot} function}
}
\value{
If \code{show.age=1}, returns a list with the following items:

\describe{

\item{x}{ a named vector with the (weighted mean) U-Pb composition }

\item{cov}{ the covariance matrix of the (weighted mean) U-Pb composition }

\item{mswd}{ a vector with three items (\code{equivalence},
\code{concordance} and \code{combined}) containing the MSWD (Mean
of the Squared Weighted Deviates, a.k.a the reduced Chi-squared
statistic) of isotopic equivalence, age concordance and combined
goodness of fit, respectively. }

\item{p.value}{ a vector with three items (\code{equivalence},
\code{concordance} and \code{combined}) containing the p-value of
the Chi-square test for isotopic equivalence, age concordance and
combined goodness of fit, respectively. }

\item{df}{ a three-element vector with the number of degrees of
freedom used for the \code{mswd} calculation. }

\item{age}{a 4-element vector with:\cr

\code{t}: the concordia age (in Ma)\cr

\code{s[t]}: the estimated uncertainty of \code{t}\cr

\code{ci[t]}: the \eqn{100(1-\alpha)\%} confidence interval of

\code{t} for the appropriate degrees of freedom\cr

\code{disp[t]}: the studentised \eqn{100(1-\alpha)\%} confidence
interval for \code{t} augmented by \eqn{\sqrt{mswd}} to account for
overdispersed datasets.
}

}

If \code{show.age=2}, \code{3} or \code{4}, returns a list with the
following items:

\describe{

\item{model}{the fitting model (\code{=show.age-1}).}

\item{par}{a vector with the upper and lower intercept ages (if
\code{type=1}) or the lower intercept age and common Pb
intercept(s) (if \code{type=2}). If \code{show.age=4}, includes an
overdispersion term as well.}

\item{cov}{ the covariance matrix of the elements in \code{par}.}

\item{logpar}{the logarithm of \code{par}}

\item{logcov}{the logarithm of \code{cov}}

\item{err}{ a matrix with the following rows:

\code{s}: the estimated standard deviation for \code{x}

\code{ci}: the \eqn{100(1-\alpha)\%} confidence interval of
\code{x} for the appropriate degrees of freedom

\code{disp[t]}: the studentised \eqn{100(1-\alpha)\%} confidence
interval for \code{x} augmented by \eqn{\sqrt{mswd}} to account for
overdispersed datasets (only reported if \code{show.age=2}).  }

\item{df}{ the degrees of freedom of the concordia fit (concordance
+ equivalence)}

\item{p.value}{ p-value of a Chi-square test for age homogeneity
(only reported if \code{ type=3}).}

\item{mswd}{ mean square of the weighted deviates -- a
goodness-of-fit measure. \code{mswd > 1} indicates overdispersion
w.r.t the analytical uncertainties (not reported if
\code{show.age=3}).}

\item{n}{ the number of aliquots in the dataset }

}
}
\description{
Plots U-Pb data on Wetherill, Tera-Wasserburg or U-Th-Pb concordia
diagrams, calculates concordia ages and compositions, evaluates the
equivalence of multiple
(\eqn{^{206}}Pb/\eqn{^{238}}U-\eqn{^{207}}Pb/\eqn{^{235}}U,
\eqn{^{207}}Pb/\eqn{^{206}}Pb-\eqn{^{206}}Pb/\eqn{^{238}}U, or
\eqn{^{208}}Th/\eqn{^{232}}Th-\eqn{^{206}}Pb/\eqn{^{238}}U)
compositions, computes the weighted mean isotopic composition and
the corresponding concordia age using the method of maximum
likelihood, computes the MSWD of equivalence and concordance and
their respective Chi-squared p-values. Performs linear regression
and computes the upper and lower intercept ages (for Wetherill) or
the lower intercept age and the \eqn{^{207}}Pb/\eqn{^{206}}Pb
intercept (for Tera-Wasserburg), taking into account error
correlations and decay constant uncertainties.
}
\details{
The concordia diagram is a graphical means of assessing the
internal consistency of U-Pb data. It sets out the measured
\eqn{^{206}}Pb/\eqn{^{238}}U- and
\eqn{^{207}}Pb/\eqn{^{235}}U-ratios against each other (`Wetherill'
diagram); or, equivalently, the \eqn{^{207}}Pb/\eqn{^{206}}Pb- and
\eqn{^{206}}Pb/\eqn{^{238}}U-ratios (`Tera-Wasserburg'
diagram). Alternatively, for data format 7 and 8, it is also
possible to plot \eqn{^{208}}Pb/\eqn{^{232}}Th against the
\eqn{^{206}}Pb/\eqn{^{238}}U.  The space of concordant isotopic
compositions is marked by a curve, the `concordia line'. Isotopic
ratio measurements are shown as 100(1-\code{alpha})\% confidence
ellipses. Concordant samples plot near to, or overlap with, the
concordia line. They represent the pinnacle of geochronological
robustness. Samples that plot away from the concordia line but are
aligned along a linear trend form an isochron (or `discordia' line)
that can be used to infer the composition of the non-radiogenic
(`common') lead or to constrain the timing of prior lead loss.
}
\examples{
attach(examples)
concordia(UPb,show.age=2)

dev.new()
concordia(UPb,type=1,xlim=c(24.9,25.4),
          ylim=c(0.0508,0.0518),ticks=249:254,exterr=TRUE)

dev.new()
concordia(UPb,type=2,show.age=2,anchor=list(TRUE,0))

}
\references{
Ludwig, K.R., 1998. On the treatment of concordant
    uranium-lead ages. Geochimica et Cosmochimica Acta, 62(4),
    pp.665-676.
}
