% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cad.R
\name{cad}
\alias{cad}
\title{Plot continuous data as cumulative age distributions}
\usage{
cad(x, method = NA, pch = NA, verticals = TRUE, xlab = "age [Ma]",
  colmap = "heat.colors", col = "black", ...)
}
\arguments{
\item{x}{an object of class \code{UPb} or \code{detritals}}

\item{method}{a string indicating what kind of age should be plotted.

If \code{x} has class \code{UPb}, \code{type} could be one of
either \code{t.75}, \code{t.68} (default), \code{t.76} or
\code{t.conc}}

\item{pch}{(optional) plot character}

\item{verticals}{boolean flag indicating if the horizontal lines of
the CAD should be connected by vertical lines}

\item{xlab}{x-axis label}

\item{colmap}{an optional string with the name of one of \code{R}'s
built-in colour palettes (e.g., heat.colors, terrain.colors,
topo.colors, cm.colors), which are to be used for plotting data
of class \code{detritals}.}

\item{col}{colour to give to single sample datasets (i.e. not of
class \code{detritals})}

\item{...}{optional arguments to the generic \code{plot} function}
}
\description{
Plot a dataset as a Cumulative Age Distribution (CADs), also known
as a `empirical cumulative distribution function'.
}
\examples{
data(examples)
cad(examples$DZ)
}

