% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isochron.R
\name{isochron}
\alias{isochron}
\alias{isochron.default}
\alias{isochron.ArAr}
\alias{isochron.PbPb}
\alias{isochron.RbSr}
\alias{isochron.ReOs}
\alias{isochron.SmNd}
\alias{isochron.LuHf}
\alias{isochron.ThU}
\alias{isochron.UThHe}
\title{Calculate and plot isochrons}
\usage{
isochron(x, ...)

\method{isochron}{default}(x, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, levels = NA,
  ellipse.col = c("#00FF0080", "#FF000080"), line.col = "red", lwd = 2,
  title = TRUE, model = 1, ...)

\method{isochron}{ArAr}(x, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, levels = NA,
  ellipse.col = c("#00FF0080", "#FF000080"), inverse = TRUE,
  line.col = "red", lwd = 2, plot = TRUE, exterr = TRUE, model = 1,
  ...)

\method{isochron}{PbPb}(x, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, levels = NA,
  ellipse.col = c("#00FF0080", "#FF000080"), inverse = TRUE,
  line.col = "red", lwd = 2, plot = TRUE, exterr = TRUE, model = 1,
  ...)

\method{isochron}{RbSr}(x, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, levels = NA,
  ellipse.col = c("#00FF0080", "#FF000080"), line.col = "red", lwd = 2,
  plot = TRUE, exterr = TRUE, model = 1, ...)

\method{isochron}{ReOs}(x, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, levels = NA,
  ellipse.col = c("#00FF0080", "#FF000080"), line.col = "red", lwd = 2,
  plot = TRUE, exterr = TRUE, model = 1, ...)

\method{isochron}{SmNd}(x, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, levels = NA,
  ellipse.col = c("#00FF0080", "#FF000080"), line.col = "red", lwd = 2,
  plot = TRUE, exterr = TRUE, model = 1, ...)

\method{isochron}{LuHf}(x, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, levels = NA,
  ellipse.col = c("#00FF0080", "#FF000080"), line.col = "red", lwd = 2,
  plot = TRUE, exterr = TRUE, model = 1, ...)

\method{isochron}{ThU}(x, type = 2, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, levels = NA,
  ellipse.col = c("#00FF0080", "#FF000080"), line.col = "red", lwd = 2,
  plot = TRUE, exterr = TRUE, model = 1, ...)

\method{isochron}{UThHe}(x, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, line.col = "red", lwd = 2,
  plot = TRUE, model = 1, ...)
}
\arguments{
\item{x}{EITHER a matrix with the following five columns:

\describe{

\item{X}{the x-variable}

\item{sX}{the standard error of \code{X}}

\item{Y}{the y-variable}

\item{sY}{the standard error of \code{Y}}

\item{rXY}{the correlation coefficient of \code{X} and \code{Y}}

}

OR

an object of class \code{ArAr}, \code{PbPb}, \code{ReOs},
\code{RbSr}, \code{SmNd}, \code{LuHf}, \code{UThHe} or \code{ThU}.}

\item{...}{optional arguments to be passed on to the
generic plot function if \code{model=2}}

\item{xlim}{2-element vector with the plot limits of the x-axis}

\item{ylim}{2-element vector with the plot limits of the y-axis}

\item{alpha}{confidence cutoff for the error ellipses}

\item{sigdig}{the number of significant digits of the numerical
values reported in the title of the graphical output}

\item{show.numbers}{logical flag (\code{TRUE} to show grain numbers)}

\item{levels}{a vector with additional values to be displayed as
different background colours within the error ellipses.}

\item{ellipse.col}{a vector of two background colours for the error
ellipses. If \code{levels=NA}, then only the first colour will
be used. If \code{levels} is a vector of numbers, then
\code{ellipse.col} is used to construct a colour ramp.}

\item{line.col}{colour of the isochron line}

\item{lwd}{line width}

\item{title}{add a title to the plot?}

\item{model}{construct the isochron using either:

\enumerate{

\item{Error weighted least squares regression}

\item{Ordinary least squares regression}

}}

\item{inverse}{if \code{TRUE} and \code{x} has class \code{ArAr},
    plots \eqn{^{36}}Ar/\eqn{^{40}}Ar
    vs. \eqn{^{39}}Ar/\eqn{^{40}}Ar.

if \code{TRUE} and \code{x} has class \code{PbPb}, plots
\eqn{^{207}}Pb/\eqn{^{206}}Pb vs. \eqn{^{204}}Pb/\eqn{^{206}}Pb.}

\item{plot}{if \code{FALSE}, suppresses the graphical output}

\item{exterr}{propagate external sources of uncertainty (J, decay constant)?}

\item{type}{following the classification of
Ludwig and Titterington (1994), one of either:

\enumerate{

\item `Rosholt type-II' isochron, setting out
\eqn{^{230}}Th/\eqn{^{232}}Th vs. \eqn{^{238}}U/\eqn{^{232}}Th

\item `Osmond type-II' isochron, setting out \eqn{^{230}}Th/\eqn{^{238}}U
vs. \eqn{^{232}}Th/\eqn{^{238}}U

\item `Rosholt type-II' isochron, setting out \eqn{^{234}}U/\eqn{^{232}}Th
vs. \eqn{^{238}}U/\eqn{^{232}}Th

\item `Osmond type-II' isochron, setting out \eqn{^{234}}U/\eqn{^{238}}U
vs. \eqn{^{232}}Th/\eqn{^{238}}U

}}
}
\value{
if \code{x} has class \code{PbPb}, \code{ArAr},
    \code{RbSr}, \code{SmNd}, \code{ReOs} or \code{LuHf},
    \code{ThU}, or \code{UThHe}, returns a list with the following
    items:

\describe{

\item{a}{the intercept of the straight line fit and its standard
error.}

\item{b}{the slope of the fit and its standard error.}

\item{cov.ab}{the covariance of the slope and intercept}

\item{mswd}{the mean square of the residuals (a.k.a
    `reduced Chi-square') statistic}

\item{p.value}{the p-value of a Chi-square test for linearity}

\item{y0}{the atmospheric \eqn{^{40}}Ar/\eqn{^{36}}Ar or initial
\eqn{^{207}}Pb/\eqn{^{204}}Pb, \eqn{^{187}}Os/\eqn{^{188}}Os,
\eqn{^{87}}Sr/\eqn{^{86}}Sr, \eqn{^{143}}Nd/\eqn{^{144}}Nd or
\eqn{^{176}}Hf/\eqn{^{177}}Hf ratio and its standard error.}

\item{age}{the \eqn{^{207}}Pb/\eqn{^{206}}Pb,
\eqn{^{40}}Ar/\eqn{^{39}}Ar, \eqn{^{187}}Os/\eqn{^{187}}Re,
\eqn{^{87}}Sr/\eqn{^{86}}Sr, \eqn{^{143}}Nd/\eqn{^{144}}Nd or
\eqn{^{176}}Hf/\eqn{^{177}}Hf age and its standard error.}

}

if \code{plot=FALSE}, and \code{x} has class \code{ThU}:

\describe{

\item{par}{if \code{type=1} or \code{type=3}: the best fitting
\eqn{^{230}}Th/\eqn{^{232}}Th intercept,
\eqn{^{230}}Th/\eqn{^{238}}U slope, \eqn{^{234}}U/\eqn{^{232}}Th
intercept and \eqn{^{234}}U/\eqn{^{238}}U slope, OR, if
\code{type=2} or \code{type=4}: the best fitting
\eqn{^{234}}U/\eqn{^{238}}U intercept,
\eqn{^{230}}Th/\eqn{^{232}}Th slope, \eqn{^{234}}U/\eqn{^{238}}U
intercept and \eqn{^{234}}U/\eqn{^{232}}Th slope.  }

\item{cov}{the covariance matrix of \code{par}.}

\item{a}{if \code{type=1}: the \eqn{^{230}}Th/\eqn{^{232}}Th
intercept; if \code{type=2}: the \eqn{^{230}}Th/\eqn{^{238}}U
intercept; if \code{type=3}: the \eqn{^{234}}Th/\eqn{^{232}}Th
intercept; if \code{type=4}: the \eqn{^{234}}Th/\eqn{^{238}}U
intercept.}

\item{b}{if \code{type=1}: the \eqn{^{230}}Th/\eqn{^{238}}U slope;
if \code{type=2}: the \eqn{^{230}}Th/\eqn{^{232}}Th slope; if
\code{type=3}: the \eqn{^{234}}U/\eqn{^{238}}U slope; if
\code{type=4}: the \eqn{^{234}}U/\eqn{^{232}}Th slope.}

\item{cov.ab}{the covariance between \code{a} and \code{b}.}

\item{mswd}{the mean square of the residuals (a.k.a `reduced
    Chi-square') statistic.}

\item{p.value}{the p-value of a Chi-square test for linearity.}

\item{y0}{the initial \eqn{^{234}}U/\eqn{^{238}}U-ratio and its
standard error.}

\item{age}{the Th-U isochron age and its standard error.}

}
}
\description{
Plots cogenetic Ar-Ar, Pb-Pb, Rb-Sr, Sm-Nd, Re-Os, Lu-Hf, U-Th-He or Th-U
data as X-Y scatterplots, fits an isochron curve through them using
the \code{york} function, and computes the corresponding isochron
age, including decay constant uncertainties.
}
\examples{
data(examples)
isochron(examples$ArAr)

}
