% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ludwig.R
\name{ludwig}
\alias{ludwig}
\alias{ludwig.default}
\alias{ludwig.UPb}
\title{Linear regression of X,Y,Z-variables with correlated errors, taking
into account decay constant uncertainties.}
\usage{
ludwig(x, ...)

\method{ludwig}{default}(x, ...)

\method{ludwig}{UPb}(x, exterr = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{UPb} with \code{x$format > 3}.}

\item{...}{optional arguments}

\item{exterr}{propagate external sources of uncertainty (e.g., decay constant)?}
}
\description{
Implements the maximum likelihood algorithm of Ludwig (1998)
}
\examples{
f <- system.file("UPb4.csv",package="IsoplotR")
d <- read.data(f,method="U-Pb",format=4)
fit <- ludwig(d)
}
\references{
Ludwig, K.R., 1998. On the treatment of concordant uranium-lead
ages. Geochimica et Cosmochimica Acta, 62(4), pp.665-676.
}
