% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/titterington.R
\name{titterington}
\alias{titterington}
\title{Linear regression of X,Y,Z-variables with correlated errors}
\usage{
titterington(x)
}
\arguments{
\item{x}{a \code{[9 x n]} matrix with the following columns:
\code{X, sX, Y, sY, Z, sZ}, \code{rhoXY, rhoXZ, rhoYZ}.}
}
\value{
a four-element list of vectors containing:
    \describe{

    \item{par}{4-element vector \code{c(a,b,A,B)} where \code{a} is
              the intercept of the \code{X-Y} regression, \code{b}
              is the slope of the \code{X-Y} regression, \code{A}
              is the intercept of the \code{X-Z} regression, and
              \code{B} is the slope of the \code{X-Z} regression.}

    \item{cov}{\code{[4 x 4]}-element covariance matrix of \code{par}}

    \item{mswd}{the mean square of the residuals (a.k.a `reduced
                Chi-square') statistic} }
}
\description{
Implements the maximum likelihood algorithm of Ludwig and Titterington (1994)
}
\references{
Ludwig, K.R. and Titterington, D.M., 1994. Calculation
of \eqn{^{230}}Th/U isochrons, ages, and errors. Geochimica et
Cosmochimica Acta, 58(22), pp.5031-5042.
}
