% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read.data}
\alias{read.data}
\alias{read.data.default}
\alias{read.data.matrix}
\title{Read geochronology data}
\usage{
read.data(x, ...)

\method{read.data}{default}(x, method = "U-Pb", format = 1, ...)

\method{read.data}{matrix}(x, method = "U-Pb", format = 1, ...)
}
\arguments{
\item{x}{either a file name (\code{.csv} format) OR a matrix}

\item{...}{optional arguments to the \code{read.csv} function}

\item{method}{one of \code{'U-Pb'}, \code{'Ar-Ar'},
\code{'detritals'}, \code{Rb-Sr}, \code{Sm-Nd}, \code{Re-Os},
\code{'U-Th-He'}, \code{'fissiontracks'} or \code{'other'}}

\item{format}{formatting option, depends on the value of
    \code{method}.

if \code{method='U-Pb'}, then \code{format} is one of either:

\enumerate{
\item{\code{7/5, s[7/5], 6/8, s[6/8], rho}}
\item{\code{8/6, s[8/6], 7/6, s[7/6] (, rho)}}
\item{\code{X=7/6, s[X], Y=7/5, s[Y], Z=6/8, s[Z] (, rho[X,Y]) (, rho[Y,Z])}}
}

where optional columns are marked in round brackets

if \code{method='Ar-Ar'}, then \code{format} is one of either:

\enumerate{
\item{\code{9/6, s[9/6], 0/6, s[0/6], rho (, 39)}}
\item{\code{6/0, s[6/0], 9/0, s[9/0] (, rho) (, 39)}}
\item{\code{9/0, s[9/0], 6/0, s[6/0], 9/6, s[9/6] (, 39)}}
}

if \code{method='Rb-Sr'}, then \code{format} is one of either:

\enumerate{
\item{\code{Rb87/Sr86, s[Rb87/Sr86], Sr87/Sr86, s[Sr87/Sr86] (, rho)}}
\item{\code{Rb, s[Rb], Sr, s[Sr], Sr87/Sr86, s[Sr87/Sr86]}}
}

where \code{Rb} and \code{Sr} are in ppm

if \code{method='Sm-Nd'}, then \code{format} is one of either:

\enumerate{
\item{\code{Sm147/Nd144, s[Sm147/Nd144], Nd143/Nd144, s[Nd143/Nd144] (, rho)}}
\item{\code{Sm, s[Sm], Nd, s[Nd], Nd143/Nd144, s[Nd143/Nd144]}}
}

where \code{Sm} and \code{Nd} are in ppm

if \code{method='Re-Os'}, then \code{format} is one of either:

\enumerate{
\item{\code{Re187/Os188, s[Re187/Os188], Os187/Os188, s[Os187/Os188] (, rho)}}
\item{\code{Re, s[Re], Os, s[Os], Os187/Os188, s[Os187/Os188]}}
}

where \code{Re} and \code{Os} are in ppm

if \code{method='fissiontracks'}, then \code{format} is one of
either:

\enumerate{
\item{the External Detector Method (EDM), which requires a
\eqn{\zeta}-calibration constant and its uncertainty, the induced
track density in a dosimeter glass, and a table with the
spontaneous and induced track densities.}

\item{LA-ICP-MS-based fission track data using the
\eqn{\zeta}-calibration method, which requires a 'session
\eqn{\zeta}' and its uncertainty and a table with the number of
spontaneous tracks, the area over which these were counted and one
or more U/Ca- or U-concentration measurements and their analytical
uncertainties.}

\item{LA-ICP-MS-based fission track data using the 'absolute
dating' method, which only requires a table with the the number of
spontaneous tracks, the area over which these were counted and one
or more U/Ca- or U-concentration measurements and their analytical
uncertainties.}  }}
}
\value{
an object of class \code{UPb}, \code{ArAr}, \code{UThHe},
    \code{ReOs}, \code{SmNd}, \code{RbSr}, \code{detritals},
    \code{fissiontracks} or \code{other}
}
\description{
Cast a \code{.csv} file or a matrix into one of \code{IsoplotR}'s
data classes
}
\details{
IsoplotR provides the following example input files:

\itemize{
\item{U-Pb: \code{UPb1.csv}, \code{UPb2.csv}, \code{UPb3.csv}}
\item{Ar-Ar: \code{ArAr1.csv}, \code{ArAr2.csv}, \code{ArAr3.csv}}
\item{Re-Os: \code{ReOs1.csv}, \code{ReOs2.csv}}
\item{Sm-Nd: \code{SmNd1.csv}, \code{SmNd2.csv}}
\item{Rb-Sr: \code{RbSr1.csv}, \code{RbSr2.csv}}
\item{fissiontracks: \code{FT1.csv}, \code{FT2.csv}, \code{FT3.csv}}
\item{U-Th-He: \code{UThHe.csv}, \code{UThSmHe.csv}}
\item{detritals: \code{Namib.csv}}
\item{other: \code{MountTom.csv}, \code{average.csv}, \code{spectrum.csv}}
}

The contents of these files can be viewed using the
\code{system.file(...)} function.
}
\examples{
file.show(system.file("spectrum.csv",package="IsoplotR"))

f1 <- system.file("UPb1.csv",package="IsoplotR")
d1 <- read.data(f1,method="U-Pb",format=1)
concordia(d1)

f2 <- system.file("ArAr1.csv",package="IsoplotR")
d2 <- read.data(f2,method="Ar-Ar",format=1)
agespectrum(d2)

f3 <- system.file("ReOs1.csv",package="IsoplotR")
d3 <- read.data(f3,method="Re-Os",format=1)
isochron(d2)

f4 <- system.file("FT1.csv",package="IsoplotR")
d4 <- read.data(f4,method="fissiontracks",format=1)
radialplot(d4)

f5 <- system.file("UThSmHe.csv",package="IsoplotR")
d5 <- read.data(f5,method="U-Th-He")
helioplot(d5)

#  one detrital zircon U-Pb file (detritals.csv)
f6 <- system.file("Namib.csv",package="IsoplotR")
d6 <- read.data(f6,method="detritals")
kde(d6)

#  three `other' files (MountTom.csv, spectrum.csv, average.csv)
f7 <- system.file("MountTom.csv",package="IsoplotR")
d7 <- read.data(f7,method="other")
radialplot(d7)

}

