% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read.matrix}
\alias{read.matrix}
\title{Create a geochronological data object}
\usage{
read.matrix(x, method, format)
}
\arguments{
\item{x}{matrix with U-Pb data}

\item{method}{one of 'U-Pb', 'Ar-Ar', 'Rb-Sr', 'Sm-Nd', 'Re-Os', 'U-Th-He'
'fission tracks', 'cosmogenic nuclides' or 'other'}

\item{format}{formatting option [integer]}
}
\description{
Cast a matrix of data into one of IsoplotR's input formats
}
\examples{
fname <- system.file("UPb.csv",package="IsoplotR")
dat <- read.csv(fname,row.names=1,header=TRUE)
UPb <- read.matrix(dat,method='U-Pb',format=1)
concordia.plot(UPb)
}

