% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findMAIN.r
\name{findMAIN}
\alias{findMAIN}
\title{findMAIN.}
\usage{
findMAIN(
  spec,
  adductmz = NULL,
  ionmode = c("positive", "negative")[1],
  adducthyp = NULL,
  ms2spec = NULL,
  rules = NULL,
  mzabs = 0.01,
  ppm = 5,
  mainpkthr = 0.005,
  collapseResults = TRUE
)
}
\arguments{
\item{spec}{A mass spectrum. Either a matrix or data frame, the first two columns of which are assumed to contain the 'mz' and 'intensity' values, respectively.}

\item{adductmz}{Manually specified peak for which \code{adducthyp} should be tested, or 'NULL' (default), to test all main peaks. What is a main peak, is governed by \code{mainpkthr}.}

\item{ionmode}{Ionization mode, either "positive" or "negative". Can be abbreviated.}

\item{adducthyp}{Adduct hypotheses to test for each main peak. Defaults to \code{c("[M+H]+","[M+Na]+","[M+K]+")} for positive mode and \code{c("[M-H]-","[M+Cl]-","[M+HCOOH-H]-")}.}

\item{ms2spec}{Second spectrum limiting main peak selection. If available, MS^E or bbCID spectra may allow further exclusion of false positive adduct ions, as ions of the intact molecule (protonated molecule, adduct ions) should have lower intensity in the high-energy trace than in low-energy trace.}

\item{rules}{Adduct/fragment relationships to test, e.g. \code{c("[M+Na]+", "[M+H-H2O]+")}, or 'NULL' for default set (see \code{\link{Adducts}})}

\item{mzabs}{Allowed mass error, absolute (Da).}

\item{ppm}{Allowed mass error, relative (ppm), which is _added_ to 'mzabs'.}

\item{mainpkthr}{Intensity threshold for main peak selection, relative to base peak.}

\item{collapseResults}{If a neutral mass hypothesis was found more than once (due to multiple adducts suggesting the same neutral mass), return only the one with the highest adduct peak. Should normally kept at \code{TRUE}, the default.}
}
\value{
A list-like 'findMAIN' object for which 'print', 'summary' and 'plot' methods are available.
}
\description{
\code{findMAIN} will evaluate an ESI spectrum for the potential main adducts, 
    rank obtained suggestions and allow the deduction of the neutral mass of the measured 
    molecule.
}
\details{
Electrospray ionization (ESI) mass spectra frequently contain a number of different 
    adduct ions, multimers and in-source fragments \code{[M+H]+, [M+Na]+, [2M+H]+, [M+H-H2O]+}, 
    making it difficult to decide on the compound's neutral mass. This functions aims 
    at determining the main adduct ion and its type (protonated, sodiated etc.) of a spectrum, 
    allowing subsequent database searches e.g. using MS-FINDER, SIRIUS or similar.
}
\examples{
\donttest{
utils::data(esi_spectrum, package = "InterpretMSSpectrum")
fmr <- findMAIN(esi_spectrum)
plot(fmr)
head(summary(fmr))
InterpretMSSpectrum(fmr[[1]], precursor=263, param="ESIpos")
}

}
\references{
Jaeger C, Meret M, Schmitt CA, Lisec J (2017), <doi:10.1002/rcm.7905>.
}
