% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Functions.R
\name{topkGenes}
\alias{topkGenes}
\title{topkGenes}
\usage{
topkGenes(jointModelResult, subset_type, ranking, k = 10, sigLevel = 0.01)
}
\arguments{
\item{jointModelResult}{Data frame, containing the results from the fitJM function.}

\item{subset_type}{Character string to specify the set of genes. It can have four values: "Effect" for only differentially expressed genes, "Correlation" for only correlated genes, "Effect and Correlation" for genes which are both differentially expressed & correlated and "Other" for the genes which are neither differentially expressed nor correlated.}

\item{ranking}{Character string, specifying one of the columns of the jointModelResult data frame, based on the genes will be ranked within the selected subset.}

\item{k}{Integer, specifying the number of genes, to be returned from the list of top genes. Default is 10.}

\item{sigLevel}{Numeric between 0 and 1, specifying the level of significance, used to select the subset of genes.}
}
\value{
A data frame containing top k genes according to the specified criteria from the specified set of genes.
}
\description{
The topkGenes function is to identify the top genes based on different criteria.
}
\details{
Returned data frame contains 6 columns, named as "Genes","FP-Effect", "p-adj(Effect)", "Unadj.Asso.","Adj.Asso.", "p-adj(Adj.Asso.)".
}
\examples{
\dontrun{
topkGenes(jointModelResult=jmRes,subset_type="Effect",ranking="Pearson",k=10,sigLevel = 0.05)
}
}

