/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleQRDecomposition;
import cern.colt.matrix.tdouble.impl.DenseColumnDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import java.util.Random;

public class TestDenseDoubleQRDecomposition {
    public static void main(String[] stringArray) {
        for (int i = 0; i < 20; ++i) {
            int n;
            int n2;
            int n3 = 600;
            int n4 = 400;
            int n5 = 5;
            Random random = new Random(0L);
            DenseColumnDoubleMatrix2D denseColumnDoubleMatrix2D = new DenseColumnDoubleMatrix2D(n3, n4);
            DenseColumnDoubleMatrix2D denseColumnDoubleMatrix2D2 = new DenseColumnDoubleMatrix2D(n3, n4);
            DenseColumnDoubleMatrix2D denseColumnDoubleMatrix2D3 = new DenseColumnDoubleMatrix2D(n3, n5);
            DenseColumnDoubleMatrix2D denseColumnDoubleMatrix2D4 = new DenseColumnDoubleMatrix2D(n3, n5);
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n4; ++n) {
                    ((DoubleMatrix2D)denseColumnDoubleMatrix2D).setQuick(n2, n, 0.5 - random.nextDouble());
                    ((DoubleMatrix2D)denseColumnDoubleMatrix2D2).setQuick(n2, n, ((DoubleMatrix2D)denseColumnDoubleMatrix2D).getQuick(n2, n));
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n5; ++n) {
                    ((DoubleMatrix2D)denseColumnDoubleMatrix2D3).setQuick(n2, n, 0.5 - random.nextDouble());
                    ((DoubleMatrix2D)denseColumnDoubleMatrix2D4).setQuick(n2, n, ((DoubleMatrix2D)denseColumnDoubleMatrix2D3).getQuick(n2, n));
                }
            }
            TestDenseDoubleQRDecomposition.testQR(denseColumnDoubleMatrix2D, denseColumnDoubleMatrix2D2, denseColumnDoubleMatrix2D3, denseColumnDoubleMatrix2D4);
        }
        System.out.println("All finished");
        System.exit(0);
    }

    private static void testQR(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, DoubleMatrix2D doubleMatrix2D3, DoubleMatrix2D doubleMatrix2D4) {
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        double d = 1.0E-10;
        DenseDoubleQRDecomposition denseDoubleQRDecomposition = new DenseDoubleQRDecomposition(doubleMatrix2D2);
        DoubleMatrix2D doubleMatrix2D5 = denseDoubleQRDecomposition.getQ(false);
        DoubleMatrix2D doubleMatrix2D6 = denseDoubleQRDecomposition.getR(false);
        DoubleMatrix2D doubleMatrix2D7 = doubleMatrix2D4.copy();
        denseDoubleQRDecomposition.solve(doubleMatrix2D7);
        System.out.print("\n");
        System.out.print("------ DenseDoubleQRFactorization tests-------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", n, n2));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", d));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        int n3 = TestDenseDoubleQRDecomposition.check_orthogonality(n, doubleMatrix2D5, d);
        int n4 = TestDenseDoubleQRDecomposition.checkFactorization(doubleMatrix2D, doubleMatrix2D5, doubleMatrix2D6, d);
        int n5 = TestDenseDoubleQRDecomposition.checkSolution(doubleMatrix2D, doubleMatrix2D3, doubleMatrix2D7.viewPart(0, 0, doubleMatrix2D.columns(), doubleMatrix2D7.columns()).copy(), d);
        if (n5 == 0 & n4 == 0 & n3 == 0) {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGEQRF + DORMQR + DTRSM .... PASSED !\n");
            System.out.print("************************************************\n");
        } else {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGEQRF + DORMQR + DTRSM .... FAILED !\n");
            System.out.print("************************************************\n");
        }
    }

    private static int check_orthogonality(int n, DoubleMatrix2D doubleMatrix2D, double d) {
        int n2;
        double d2 = 1.0;
        double d3 = -1.0;
        DoubleMatrix2D doubleMatrix2D2 = DoubleFactory2D.dense.identity(doubleMatrix2D.columns());
        doubleMatrix2D2 = doubleMatrix2D.zMult(doubleMatrix2D, doubleMatrix2D2, d2, d3, true, false);
        double d4 = DenseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix2D2);
        System.out.print("============\n");
        System.out.print("Checking the orthogonality of Q \n");
        System.out.print(String.format("||Id-Q'*Q||_oo / (N*eps) = %e\n", d4 / ((double)n * d)));
        if (d4 / ((double)n * d) > 10.0) {
            System.out.print("-- Orthogonality is suspicious ! \n");
            n2 = 1;
        } else {
            System.out.print("-- Orthogonality is CORRECT ! \n");
            n2 = 0;
        }
        return n2;
    }

    private static int checkFactorization(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, DoubleMatrix2D doubleMatrix2D3, double d) {
        int n;
        DoubleProperty.DEFAULT.checkDense(doubleMatrix2D);
        DoubleProperty.DEFAULT.checkDense(doubleMatrix2D2);
        DoubleProperty.DEFAULT.checkDense(doubleMatrix2D3);
        int n2 = doubleMatrix2D.rows();
        int n3 = doubleMatrix2D.columns();
        DoubleMatrix2D doubleMatrix2D4 = doubleMatrix2D2.copy();
        double d2 = 1.0;
        DoubleMatrix2D doubleMatrix2D5 = doubleMatrix2D.copy();
        doubleMatrix2D4 = doubleMatrix2D4.zMult(doubleMatrix2D3, null, d2, 0.0, false, false);
        doubleMatrix2D5.assign(doubleMatrix2D4, DoubleFunctions.plusMultFirst(-1.0));
        double d3 = DenseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix2D5);
        double d4 = DenseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix2D);
        System.out.print("============\n");
        System.out.print("Checking the QR Factorization \n");
        System.out.print(String.format("-- ||QR-A||_oo/(||A||_oo.N.eps) = %e \n", d3 / (d4 * (double)n3 * d)));
        if (d3 / (d4 * (double)n3 * d) > 10.0) {
            System.out.print("-- Factorization is suspicious ! \n");
            n = 1;
        } else {
            System.out.print("-- Factorization is CORRECT ! \n");
            n = 0;
        }
        return n;
    }

    private static int checkSolution(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, DoubleMatrix2D doubleMatrix2D3, double d) {
        int n;
        DoubleProperty.DEFAULT.checkDense(doubleMatrix2D);
        DoubleProperty.DEFAULT.checkDense(doubleMatrix2D2);
        DoubleProperty.DEFAULT.checkDense(doubleMatrix2D3);
        int n2 = doubleMatrix2D.rows();
        int n3 = doubleMatrix2D.columns();
        double d2 = 1.0;
        double d3 = -1.0;
        double d4 = DenseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix2D3);
        double d5 = DenseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix2D);
        double d6 = DenseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix2D2);
        doubleMatrix2D.zMult(doubleMatrix2D3, doubleMatrix2D2, d2, d3, false, false);
        DoubleMatrix2D doubleMatrix2D4 = doubleMatrix2D.zMult(doubleMatrix2D2.viewPart(0, 0, doubleMatrix2D.rows(), doubleMatrix2D2.columns()).copy(), null, d2, d3, true, false);
        double d7 = DenseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix2D4);
        System.out.print("============\n");
        System.out.print("Checking the Residual of the solution \n");
        System.out.print(String.format("-- ||Ax-B||_oo/((||A||_oo||x||_oo+||B||_oo).N.eps) = %e \n", d7 / ((d5 * d4 + d6) * (double)n3 * d)));
        if (d7 / ((d5 * d4 + d6) * (double)n3 * d) > 10.0) {
            System.out.print("-- The solution is suspicious ! \n");
            n = 1;
        } else {
            System.out.print("-- The solution is CORRECT ! \n");
            n = 0;
        }
        return n;
    }
}

