/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.colt.matrix.tint.impl.WrapperIntMatrix2D;

public class SparseCCMIntMatrix2D
extends WrapperIntMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseIntMatrix1D[] elements;

    public SparseCCMIntMatrix2D(int n, int n2) {
        block3: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        this.elements = new SparseIntMatrix1D[n2];
        for (int i = 0; i < n2; ++i) {
            this.elements[i] = new SparseIntMatrix1D(n);
        }
    }

    public SparseIntMatrix1D[] elements() {
        return this.elements;
    }

    public int getQuick(int n, int n2) {
        return this.elements[n2].getQuick(n);
    }

    public void setQuick(int n, int n2, int n3) {
        this.elements[n2].setQuick(n, n3);
    }

    public void trimToSize() {
        for (int i = 0; i < this.columns; ++i) {
            this.elements[i].trimToSize();
        }
    }

    public SparseIntMatrix1D viewColumn(int n) {
        return this.elements[n];
    }

    protected IntMatrix2D getContent() {
        return this;
    }

    public IntMatrix2D like(int n, int n2) {
        return new SparseCCMIntMatrix2D(n, n2);
    }
}

