/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong;

import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.jet.math.tlong.LongFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Random;
import junit.framework.TestCase;
import org.junit.Test;

public abstract class LongMatrix1DTest
extends TestCase {
    protected LongMatrix1D A;
    protected LongMatrix1D B;
    protected int SIZE = 170;
    protected Random rand = new Random(0L);

    public LongMatrix1DTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.createMatrices();
        this.populateMatrices();
    }

    protected abstract void createMatrices() throws Exception;

    protected void populateMatrices() {
        int n;
        ConcurrencyUtils.setThreadsBeginN_1D(1);
        for (n = 0; n < (int)this.A.size(); ++n) {
            this.A.setQuick(n, Math.max(1L, this.rand.nextLong() % this.A.size()));
        }
        for (n = 0; n < (int)this.B.size(); ++n) {
            this.B.setQuick(n, Math.max(1L, this.rand.nextLong() % this.A.size()));
        }
    }

    protected void tearDown() throws Exception {
        this.B = null;
        this.A = null;
    }

    public void testAggregateLongLongFunctionLongFunction() {
        long l = 0L;
        for (int i = 0; i < (int)this.A.size(); ++i) {
            long l2 = this.A.getQuick(i);
            l += l2 * l2;
        }
        long l3 = this.A.aggregate(LongFunctions.plus, LongFunctions.square);
        LongMatrix1DTest.assertEquals((long)l, (long)l3);
    }

    public void testAggregateLongLongFunctionLongFunctionIntArrayList() {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < (int)this.A.size(); ++i) {
            intArrayList.add(i);
        }
        long l = 0L;
        for (int i = 0; i < (int)this.A.size(); ++i) {
            long l2 = this.A.getQuick(i);
            l += l2 * l2;
        }
        long l3 = this.A.aggregate(LongFunctions.plus, LongFunctions.square, intArrayList);
        LongMatrix1DTest.assertEquals((long)l, (long)l3);
    }

    public void testAggregateLongMatrix2DLongLongFunctionLongLongFunction() {
        long l = 0L;
        for (int i = 0; i < (int)this.A.size(); ++i) {
            long l2 = this.A.getQuick(i);
            long l3 = this.B.getQuick(i);
            l += l2 * l3;
        }
        long l4 = this.A.aggregate(this.B, LongFunctions.plus, LongFunctions.mult);
        LongMatrix1DTest.assertEquals((long)l, (long)l4);
    }

    public void testAssignLong() {
        long l = this.rand.nextLong();
        this.A.assign(l);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            LongMatrix1DTest.assertEquals((long)l, (long)this.A.getQuick(i));
        }
    }

    public void testAssignLongArray() {
        int n;
        long[] lArray = new long[(int)this.A.size()];
        for (n = 0; n < (int)this.A.size(); ++n) {
            lArray[n] = this.rand.nextLong();
        }
        this.A.assign(lArray);
        for (n = 0; n < (int)this.A.size(); ++n) {
            LongMatrix1DTest.assertEquals((long)lArray[n], (long)this.A.getQuick(n));
        }
    }

    public void testAssignLongFunction() {
        LongMatrix1D longMatrix1D = this.A.copy();
        this.A.assign(LongFunctions.neg);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            long l = -longMatrix1D.getQuick(i);
            LongMatrix1DTest.assertEquals((long)l, (long)this.A.getQuick(i));
        }
    }

    public void testAssignLongMatrix1D() {
        this.A.assign(this.B);
        LongMatrix1DTest.assertTrue((this.A.size() == this.B.size() ? 1 : 0) != 0);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            LongMatrix1DTest.assertEquals((long)this.B.getQuick(i), (long)this.A.getQuick(i));
        }
    }

    public void testAssignLongMatrix1DLongLongFunction() {
        LongMatrix1D longMatrix1D = this.A.copy();
        this.A.assign(this.B, LongFunctions.plus);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            LongMatrix1DTest.assertEquals((long)(longMatrix1D.getQuick(i) + this.B.getQuick(i)), (long)this.A.getQuick(i));
        }
    }

    public void testAssignLongProcedureLong() {
        LongProcedure longProcedure = new LongProcedure(){

            public boolean apply(long l) {
                return Math.abs(l) > 1L;
            }
        };
        LongMatrix1D longMatrix1D = this.A.copy();
        this.A.assign(longProcedure, -1L);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            if (Math.abs(longMatrix1D.getQuick(i)) > 1L) {
                LongMatrix1DTest.assertEquals((long)-1L, (long)this.A.getQuick(i));
                continue;
            }
            LongMatrix1DTest.assertEquals((long)longMatrix1D.getQuick(i), (long)this.A.getQuick(i));
        }
    }

    public void testAssignLongProcedureLongFunction() {
        LongProcedure longProcedure = new LongProcedure(){

            public boolean apply(long l) {
                return Math.abs(l) > 1L;
            }
        };
        LongMatrix1D longMatrix1D = this.A.copy();
        this.A.assign(longProcedure, LongFunctions.neg);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            if (Math.abs(longMatrix1D.getQuick(i)) > 1L) {
                LongMatrix1DTest.assertEquals((long)(-longMatrix1D.getQuick(i)), (long)this.A.getQuick(i));
                continue;
            }
            LongMatrix1DTest.assertEquals((long)longMatrix1D.getQuick(i), (long)this.A.getQuick(i));
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        int n2 = 0;
        int n3 = 0;
        while ((long)n3 < this.A.size()) {
            if (this.A.getQuick(n3) != 0L) {
                ++n2;
            }
            ++n3;
        }
        LongMatrix1DTest.assertEquals((int)n2, (int)n);
    }

    public void testEqualsLong() {
        long l = 1L;
        this.A.assign(l);
        boolean bl = this.A.equals(l);
        LongMatrix1DTest.assertTrue((boolean)bl);
        bl = this.A.equals(2L);
        LongMatrix1DTest.assertFalse((boolean)bl);
    }

    public void testEqualsObject() {
        boolean bl = this.A.equals(this.A);
        LongMatrix1DTest.assertTrue((boolean)bl);
        bl = this.A.equals(this.B);
        LongMatrix1DTest.assertFalse((boolean)bl);
    }

    public void testMaxLocation() {
        this.A.assign(0L);
        this.A.setQuick((int)this.A.size() / 3, 7L);
        this.A.setQuick((int)this.A.size() / 2, 1L);
        long[] lArray = this.A.getMaxLocation();
        LongMatrix1DTest.assertEquals((long)7L, (long)lArray[0]);
        LongMatrix1DTest.assertEquals((int)((int)this.A.size() / 3), (int)((int)lArray[1]));
    }

    public void testMinLocation() {
        this.A.assign(0L);
        this.A.setQuick((int)this.A.size() / 3, -7L);
        this.A.setQuick((int)this.A.size() / 2, -1L);
        long[] lArray = this.A.getMinLocation();
        LongMatrix1DTest.assertEquals((long)-7L, (long)lArray[0]);
        LongMatrix1DTest.assertEquals((int)((int)this.A.size() / 3), (int)((int)lArray[1]));
    }

    public void testGetNegativeValuesIntArrayListLongArrayList() {
        this.A.assign(0L);
        this.A.setQuick((int)this.A.size() / 3, -7L);
        this.A.setQuick((int)this.A.size() / 2, -1L);
        IntArrayList intArrayList = new IntArrayList();
        LongArrayList longArrayList = new LongArrayList();
        this.A.getNegativeValues(intArrayList, longArrayList);
        LongMatrix1DTest.assertEquals((int)2, (int)intArrayList.size());
        LongMatrix1DTest.assertEquals((int)2, (int)longArrayList.size());
        LongMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 3));
        LongMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 2));
        LongMatrix1DTest.assertTrue((boolean)longArrayList.contains(-7L));
        LongMatrix1DTest.assertTrue((boolean)longArrayList.contains(-1L));
    }

    public void testGetNonZerosIntArrayListLongArrayList() {
        this.A.assign(0L);
        this.A.setQuick((int)this.A.size() / 3, 7L);
        this.A.setQuick((int)this.A.size() / 2, 1L);
        IntArrayList intArrayList = new IntArrayList();
        LongArrayList longArrayList = new LongArrayList();
        this.A.getNonZeros(intArrayList, longArrayList);
        LongMatrix1DTest.assertEquals((int)2, (int)intArrayList.size());
        LongMatrix1DTest.assertEquals((int)2, (int)longArrayList.size());
        LongMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 3));
        LongMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 2));
        LongMatrix1DTest.assertTrue((boolean)longArrayList.contains(7L));
        LongMatrix1DTest.assertTrue((boolean)longArrayList.contains(1L));
    }

    public void testGetPositiveValuesIntArrayListLongArrayList() {
        this.A.assign(0L);
        this.A.setQuick((int)this.A.size() / 3, 7L);
        this.A.setQuick((int)this.A.size() / 2, 1L);
        IntArrayList intArrayList = new IntArrayList();
        LongArrayList longArrayList = new LongArrayList();
        this.A.getPositiveValues(intArrayList, longArrayList);
        LongMatrix1DTest.assertEquals((int)2, (int)intArrayList.size());
        LongMatrix1DTest.assertEquals((int)2, (int)longArrayList.size());
        LongMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 3));
        LongMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 2));
        LongMatrix1DTest.assertTrue((boolean)longArrayList.contains(7L));
        LongMatrix1DTest.assertTrue((boolean)longArrayList.contains(1L));
    }

    public void testToArray() {
        long[] lArray = this.A.toArray();
        LongMatrix1DTest.assertTrue(((int)this.A.size() == lArray.length ? 1 : 0) != 0);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            LongMatrix1DTest.assertEquals((long)lArray[i], (long)this.A.getQuick(i));
        }
    }

    public void testToArrayLongArray() {
        long[] lArray = new long[(int)this.A.size()];
        this.A.toArray(lArray);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            LongMatrix1DTest.assertEquals((long)this.A.getQuick(i), (long)lArray[i]);
        }
    }

    public void testReshapeIntInt() {
        int n = 10;
        int n2 = 17;
        LongMatrix2D longMatrix2D = this.A.reshape(n, n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                LongMatrix1DTest.assertEquals((long)this.A.getQuick(n3++), (long)longMatrix2D.getQuick(j, i));
            }
        }
    }

    public void testReshapeIntIntInt() {
        int n = 2;
        int n2 = 5;
        int n3 = 17;
        LongMatrix3D longMatrix3D = this.A.reshape(n, n2, n3);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    LongMatrix1DTest.assertEquals((long)this.A.getQuick(n4++), (long)longMatrix3D.getQuick(i, k, j));
                }
            }
        }
    }

    public void testSwap() {
        LongMatrix1D longMatrix1D = this.A.copy();
        LongMatrix1D longMatrix1D2 = this.B.copy();
        this.A.swap(this.B);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            LongMatrix1DTest.assertEquals((long)longMatrix1D2.getQuick(i), (long)this.A.getQuick(i));
            LongMatrix1DTest.assertEquals((long)longMatrix1D.getQuick(i), (long)this.B.getQuick(i));
        }
    }

    public void testViewFlip() {
        LongMatrix1D longMatrix1D = this.A.viewFlip();
        LongMatrix1DTest.assertEquals((long)((int)this.A.size()), (long)longMatrix1D.size());
        for (int i = 0; i < (int)this.A.size(); ++i) {
            LongMatrix1DTest.assertEquals((long)this.A.getQuick(i), (long)longMatrix1D.getQuick((int)this.A.size() - 1 - i));
        }
    }

    public void testViewPart() {
        LongMatrix1D longMatrix1D = this.A.viewPart(15, 11);
        for (int i = 0; i < 11; ++i) {
            LongMatrix1DTest.assertEquals((long)this.A.getQuick(15 + i), (long)longMatrix1D.getQuick(i));
        }
    }

    public void testViewSelectionLongProcedure() {
        LongMatrix1D longMatrix1D = this.A.viewSelection(new LongProcedure(){

            public boolean apply(long l) {
                return l % 2L == 0L;
            }
        });
        int n = 0;
        while ((long)n < longMatrix1D.size()) {
            long l = longMatrix1D.getQuick(n);
            if (l % 2L != 0L) {
                LongMatrix1DTest.fail();
            }
            ++n;
        }
    }

    public void testViewSelectionIntArray() {
        int[] nArray = new int[]{5, 11, 22, 37, 101};
        LongMatrix1D longMatrix1D = this.A.viewSelection(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            LongMatrix1DTest.assertEquals((long)this.A.getQuick(nArray[i]), (long)longMatrix1D.getQuick(i));
        }
    }

    public void testViewSorted() {
        LongMatrix1D longMatrix1D = this.A.viewSorted();
        for (int i = 0; i < (int)this.A.size() - 1; ++i) {
            LongMatrix1DTest.assertTrue((longMatrix1D.getQuick(i + 1) >= longMatrix1D.getQuick(i) ? 1 : 0) != 0);
        }
    }

    public void testViewStrides() {
        int n = 3;
        LongMatrix1D longMatrix1D = this.A.viewStrides(n);
        int n2 = 0;
        while ((long)n2 < longMatrix1D.size()) {
            LongMatrix1DTest.assertEquals((long)this.A.getQuick(n2 * n), (long)longMatrix1D.getQuick(n2));
            ++n2;
        }
    }

    public void testZDotProductLongMatrix1D() {
        long l = this.A.zDotProduct(this.B);
        long l2 = 0L;
        for (int i = 0; i < (int)this.A.size(); ++i) {
            l2 += this.A.getQuick(i) * this.B.getQuick(i);
        }
        LongMatrix1DTest.assertEquals((long)l2, (long)l);
    }

    public void testZDotProductLongMatrix1DIntInt() {
        long l = this.A.zDotProduct(this.B, 5, (int)this.B.size() - 10);
        long l2 = 0L;
        for (int i = 5; i < (int)this.A.size() - 5; ++i) {
            l2 += this.A.getQuick(i) * this.B.getQuick(i);
        }
        LongMatrix1DTest.assertEquals((long)l2, (long)l);
    }

    @Test
    public void testZDotProductLongMatrix1DIntIntIntArrayList() {
        IntArrayList intArrayList = new IntArrayList();
        LongArrayList longArrayList = new LongArrayList();
        this.B.getNonZeros(intArrayList, longArrayList);
        long l = this.A.zDotProduct(this.B, 5, (int)this.B.size() - 10, intArrayList);
        long l2 = 0L;
        for (int i = 5; i < (int)this.A.size() - 5; ++i) {
            l2 += this.A.getQuick(i) * this.B.getQuick(i);
        }
        LongMatrix1DTest.assertEquals((long)l2, (long)l);
    }

    public void testZSum() {
        long l = this.A.zSum();
        long l2 = 0L;
        for (int i = 0; i < (int)this.A.size(); ++i) {
            l2 += this.A.getQuick(i);
        }
        LongMatrix1DTest.assertEquals((long)l2, (long)l);
    }
}

