/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.WrapperFloatMatrix2D;

public class SparseCCMFloatMatrix2D
extends WrapperFloatMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseFloatMatrix1D[] elements;

    public SparseCCMFloatMatrix2D(int n, int n2) {
        block3: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        this.elements = new SparseFloatMatrix1D[n2];
        for (int i = 0; i < n2; ++i) {
            this.elements[i] = new SparseFloatMatrix1D(n);
        }
    }

    public SparseFloatMatrix1D[] elements() {
        return this.elements;
    }

    public float getQuick(int n, int n2) {
        return this.elements[n2].getQuick(n);
    }

    public void setQuick(int n, int n2, float f) {
        this.elements[n2].setQuick(n, f);
    }

    public void trimToSize() {
        for (int i = 0; i < this.columns; ++i) {
            this.elements[i].trimToSize();
        }
    }

    public SparseFloatMatrix1D viewColumn(int n) {
        return this.elements[n];
    }

    protected FloatMatrix2D getContent() {
        return this;
    }

    public FloatMatrix2D like(int n, int n2) {
        return new SparseCCMFloatMatrix2D(n, n2);
    }
}

