/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math.tdcomplex;

import cern.jet.math.tdouble.DoubleConstants;

public class DComplex
extends DoubleConstants {
    public static final double abs(double[] dArray) {
        double d = Math.abs(dArray[0]);
        double d2 = Math.abs(dArray[1]);
        if (d == 0.0 && d2 == 0.0) {
            return 0.0;
        }
        if (d >= d2) {
            double d3 = dArray[1] / dArray[0];
            return d * Math.sqrt(1.0 + d3 * d3);
        }
        double d4 = dArray[0] / dArray[1];
        return d2 * Math.sqrt(1.0 + d4 * d4);
    }

    public static final double abs(double d, double d2) {
        double d3 = Math.abs(d);
        double d4 = Math.abs(d2);
        if (d3 == 0.0 && d4 == 0.0) {
            return 0.0;
        }
        if (d3 >= d4) {
            double d5 = d2 / d;
            return d3 * Math.sqrt(1.0 + d5 * d5);
        }
        double d6 = d / d2;
        return d4 * Math.sqrt(1.0 + d6 * d6);
    }

    public static final double[] acos(double[] dArray) {
        double[] dArray2 = new double[2];
        double d = 1.0 - (dArray[0] * dArray[0] - dArray[1] * dArray[1]);
        double d2 = -(dArray[0] * dArray[1] + dArray[1] * dArray[0]);
        dArray2[0] = d;
        dArray2[1] = d2;
        dArray2 = DComplex.sqrt(dArray2);
        d = -dArray2[1];
        d2 = dArray2[0];
        dArray2[0] = dArray[0] + d;
        dArray2[1] = dArray[1] + d2;
        d = Math.log(DComplex.abs(dArray2));
        dArray2[0] = d2 = Math.atan2(dArray2[1], dArray2[0]);
        dArray2[1] = -d;
        return dArray2;
    }

    public static final double arg(double[] dArray) {
        return Math.atan2(dArray[1], dArray[0]);
    }

    public static final double arg(double d, double d2) {
        return Math.atan2(d2, d);
    }

    public static final double[] asin(double[] dArray) {
        double[] dArray2 = new double[2];
        double d = 1.0 - (dArray[0] * dArray[0] - dArray[1] * dArray[1]);
        double d2 = -(dArray[0] * dArray[1] + dArray[1] * dArray[0]);
        dArray2[0] = d;
        dArray2[1] = d2;
        dArray2 = DComplex.sqrt(dArray2);
        d = -dArray2[1];
        d2 = dArray2[0];
        dArray2[0] = dArray2[0] + d;
        dArray2[1] = dArray2[1] + d2;
        d = Math.log(DComplex.abs(dArray2));
        dArray2[0] = d2 = Math.atan2(dArray2[1], dArray2[0]);
        dArray2[1] = -d;
        return dArray2;
    }

    public static final double[] atan(double[] dArray) {
        double[] dArray2 = new double[]{-dArray[0], 1.0 - dArray[1]};
        double d = dArray[0];
        double d2 = 1.0 + dArray[1];
        dArray2 = DComplex.div(dArray2, d, d2);
        d = Math.log(DComplex.abs(dArray2));
        d2 = Math.atan2(dArray2[1], dArray2[0]);
        dArray2[0] = 0.5 * d2;
        dArray2[1] = -0.5 * d;
        return dArray2;
    }

    public static final double[] conj(double[] dArray) {
        double[] dArray2 = new double[]{dArray[0], -dArray[1]};
        return dArray2;
    }

    public static final double[] cos(double[] dArray) {
        double[] dArray2 = new double[2];
        double d = -dArray[1];
        double d2 = dArray[0];
        double d3 = Math.exp(d);
        double d4 = d3 * Math.cos(d2);
        double d5 = d3 * Math.sin(d2);
        d3 = Math.exp(-d);
        double d6 = d3 * Math.cos(-d2);
        double d7 = d3 * Math.sin(-d2);
        dArray2[0] = 0.5 * (d4 += d6);
        dArray2[1] = 0.5 * (d5 += d7);
        return dArray2;
    }

    public static final double[] div(double[] dArray, double d, double d2) {
        double[] dArray2 = new double[2];
        if (Math.abs(d) >= Math.abs(d2)) {
            double d3 = 1.0 / (d + d2 * (d2 / d));
            dArray2[0] = d3 * (dArray[0] + dArray[1] * (d2 / d));
            dArray2[1] = d3 * (dArray[1] - dArray[0] * (d2 / d));
        } else {
            double d4 = 1.0 / (d * (d / d2) + d2);
            dArray2[0] = d4 * (dArray[0] * (d / d2) + dArray[1]);
            dArray2[1] = d4 * (dArray[1] * (d / d2) - dArray[0]);
        }
        return dArray2;
    }

    public static final double[] div(double[] dArray, double[] dArray2) {
        return DComplex.div(dArray, dArray2[0], dArray2[1]);
    }

    public static final double equals(double[] dArray, double[] dArray2, double d) {
        if (DComplex.abs(dArray[0] - dArray2[0], dArray[1] - dArray2[1]) <= Math.abs(d)) {
            return 1.0;
        }
        return 0.0;
    }

    public static final boolean isEqual(double[] dArray, double[] dArray2, double d) {
        return DComplex.abs(dArray[0] - dArray2[0], dArray[1] - dArray2[1]) <= Math.abs(d);
    }

    public static final double[] exp(double[] dArray) {
        double[] dArray2 = new double[2];
        double d = Math.exp(dArray[0]);
        dArray2[0] = d * Math.cos(dArray[1]);
        dArray2[1] = d * Math.sin(dArray[1]);
        return dArray2;
    }

    public static final double[] inv(double[] dArray) {
        double[] dArray2 = new double[2];
        if (dArray[1] != 0.0) {
            if (Math.abs(dArray[0]) >= Math.abs(dArray[1])) {
                double d;
                dArray2[0] = d = 1.0 / (dArray[0] + dArray[1] * (dArray[1] / dArray[0]));
                dArray2[1] = d * (-dArray[1] / dArray[0]);
            } else {
                double d = 1.0 / (dArray[0] * (dArray[0] / dArray[1]) + dArray[1]);
                dArray2[0] = d * (dArray[0] / dArray[1]);
                dArray2[1] = -d;
            }
        } else {
            dArray2[0] = 1.0 / dArray[0];
            dArray2[1] = 0.0;
        }
        return dArray2;
    }

    public static final double[] log(double[] dArray) {
        double[] dArray2 = new double[]{Math.log(DComplex.abs(dArray)), DComplex.arg(dArray)};
        return dArray2;
    }

    public static final double[] minus(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray[0] - dArray2[0], dArray[1] - dArray2[1]};
        return dArray3;
    }

    public static final double[] minusAbs(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{Math.abs(dArray[0] - dArray2[0]), Math.abs(dArray[1] - dArray2[1])};
        return dArray3;
    }

    public static final double[] mult(double[] dArray, double d) {
        double[] dArray2 = new double[]{dArray[0] * d, dArray[1] * d};
        return dArray2;
    }

    public static final double[] mult(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray[0] * dArray2[0] - dArray[1] * dArray2[1], dArray[1] * dArray2[0] + dArray[0] * dArray2[1]};
        return dArray3;
    }

    public static final double[] neg(double[] dArray) {
        double[] dArray2 = new double[]{-dArray[0], -dArray[1]};
        return dArray2;
    }

    public static final double[] plus(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray[0] + dArray2[0], dArray[1] + dArray2[1]};
        return dArray3;
    }

    public static final double[] pow(double[] dArray, double d) {
        double[] dArray2 = new double[2];
        double d2 = d * Math.log(DComplex.abs(dArray));
        double d3 = d * DComplex.arg(dArray);
        double d4 = Math.exp(d2);
        dArray2[0] = d4 * Math.cos(d3);
        dArray2[1] = d4 * Math.sin(d3);
        return dArray2;
    }

    public static final double[] pow(double d, double[] dArray) {
        double[] dArray2 = new double[2];
        double d2 = Math.log(Math.abs(d));
        double d3 = Math.atan2(0.0, d);
        double d4 = d2 * dArray[0] - d3 * dArray[1];
        double d5 = d2 * dArray[1] + d3 * dArray[0];
        double d6 = Math.exp(d4);
        dArray2[0] = d6 * Math.cos(d5);
        dArray2[1] = d6 * Math.sin(d5);
        return dArray2;
    }

    public static final double[] pow(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[2];
        double d = Math.log(DComplex.abs(dArray));
        double d2 = DComplex.arg(dArray);
        double d3 = d * dArray2[0] - d2 * dArray2[1];
        double d4 = d * dArray2[1] + d2 * dArray2[0];
        double d5 = Math.exp(d3);
        dArray3[0] = d5 * Math.cos(d4);
        dArray3[1] = d5 * Math.sin(d4);
        return dArray3;
    }

    public static final double[] sin(double[] dArray) {
        double[] dArray2 = new double[2];
        double d = -dArray[1];
        double d2 = dArray[0];
        double d3 = Math.exp(d);
        double d4 = d3 * Math.cos(d2);
        double d5 = d3 * Math.sin(d2);
        d3 = Math.exp(-d);
        double d6 = d3 * Math.cos(-d2);
        double d7 = d3 * Math.sin(-d2);
        dArray2[0] = 0.5 * (d5 -= d7);
        dArray2[1] = -0.5 * (d4 -= d6);
        return dArray2;
    }

    public static final double[] sqrt(double[] dArray) {
        double[] dArray2 = new double[2];
        double d = DComplex.abs(dArray);
        if (d > 0.0) {
            if (dArray[0] > 0.0) {
                double d2;
                dArray2[0] = d2 = Math.sqrt(0.5 * (d + dArray[0]));
                dArray2[1] = 0.5 * (dArray[1] / d2);
            } else {
                double d3 = Math.sqrt(0.5 * (d - dArray[0]));
                if (dArray[1] < 0.0) {
                    d3 = -d3;
                }
                dArray2[0] = 0.5 * (dArray[1] / d3);
                dArray2[1] = d3;
            }
        } else {
            dArray2[0] = 0.0;
            dArray2[1] = 0.0;
        }
        return dArray2;
    }

    public static final double[] square(double[] dArray) {
        return DComplex.mult(dArray, dArray);
    }

    public static final double[] tan(double[] dArray) {
        double[] dArray2 = new double[2];
        double d = -dArray[1];
        double d2 = dArray[0];
        double d3 = Math.exp(d);
        double d4 = d3 * Math.cos(d2);
        double d5 = d3 * Math.sin(d2);
        d3 = Math.exp(-d);
        double d6 = d3 * Math.cos(-d2);
        double d7 = d3 * Math.sin(-d2);
        double d8 = d4 - d6;
        double d9 = d5 - d7;
        dArray2[0] = 0.5 * d9;
        dArray2[1] = -0.5 * d8;
        d8 = d4 + d6;
        d9 = d5 + d7;
        double d10 = 0.5 * d8;
        double d11 = 0.5 * d9;
        dArray2 = DComplex.div(dArray2, d10, d11);
        return dArray2;
    }

    protected DComplex() {
    }
}

