% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selfIntersections.R
\name{untwistSec}
\alias{untwistSec}
\title{Remove self-intersections from one section of a contour}
\usage{
untwistSec(line, tol = 0, eps = 0.25)
}
\arguments{
\item{line}{N x 2 matrix of coordinates}

\item{tol}{how much of a difference between the original line and the simplified line is allowed}

\item{eps}{how much to increase \code{tol} by on each iteration}
}
\value{
n x 2 matrix of the new coordinates with self-intersections removed
}
\description{
Function to correct self-intersections in a section of a line.
}
\examples{
par(mfrow = c(1, 2))
plot(currSecEx, type = "l", main = "Original Line Section", xlab = "", ylab = "")
newSec <- untwistSec(currSecEx)
plot(newSec, type = "l", main = "New Line Section", xlab = "", ylab =  "")
}
