% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Comtradrclean_function.R
\name{Comtradrclean}
\alias{Comtradrclean}
\title{Comtradr data clean}
\usage{
Comtradrclean(DF, YEAR, threshold, cutoff)
}
\arguments{
\item{DF}{Dataframe of trade data downloaded using the comtradr package}

\item{YEAR}{Year}

\item{threshold}{Apply a threshold - TRUE, Extract the backbone - FALSE}

\item{cutoff}{Threshold - cutoff level, Backbone - significance level}
}
\value{
International Trade Network - igraph object
}
\description{
This function takes (import) trade data downloaded using the comtradr package, cleans it and transforms it into a network.
Adding a number of country level attributes to nodes in the network, including: regional partition, GDP, GDP per capita, GDP growth and FDI.
However, it is important to note the limits of using comtradr to construct a network.
Firstly when downloading the data, you must specify reporters and partners –
yet you cannot put “all” for both – only for either reporters or partners.
Then for the other you are limited to a character vector of country names,
length five or fewer. Therefore, this will not give you a full network.
However, this function can be applied to trade data downloaded from UN Comtrade (download csv and read into R as a dataframe), or any other trade data which is in the same format as the comtradr dataframe.
}
\examples{
\donttest{
##download data using comtradr
require(comtradr)

##Download the trade data for tomatoes - code 0702
##All countries, Year - 2016
ex_2 <- ct_search(reporters = "All",
              partners = c("USA","China",
              "Germany","Canada","Mexico"),
              trade_direction = "imports",
              start_date = "2016-01-01",
              end_date = "2016-12-31",
              commod_codes = "0702")

##this then gives a data frame which
##we can clean using the following function:
tomatoesITN<-Comtradrclean(ex_2,2016,TRUE,0.01)

##We apply a threshold - only retaining ties that are at least 0.01\%
##of total tomatoes trade (amngst these countries)

}
}
