% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial.R
\name{iscambinomtest}
\alias{iscambinomtest}
\title{Exact Binomial Test}
\usage{
iscambinomtest(
  observed,
  n,
  hypothesized = NULL,
  alternative,
  conf.level = NULL,
  verbose = TRUE
)
}
\arguments{
\item{observed}{The observed number of successes or sample proportion (assumed
to be proportion if value less than one.)}

\item{n}{number of trials.}

\item{hypothesized}{hypothesized probability of success.}

\item{alternative}{"less", "greater", or "two.sided"}

\item{conf.level}{Confidence level for a two-sided confidence interval.}

\item{verbose}{Logical, defaults to \code{TRUE}. Set to \code{FALSE} to suppress messages}
}
\value{
a list of the p-value along with lower and upper bound for the calculated confidence interval.
}
\description{
\code{binomtest} calculates performs an exact binomial test and graphs the
binomial distribution and/or binomial confidence interval.
}
\examples{

iscambinomtest(
  observed = 17,
  n = 25,
  hypothesized = 0.5,
  alternative = "greater"
)

iscambinomtest(
  observed = 12,
  n = 80,
  hypothesized = 0.10,
  alternative = "two.sided",
  conf.level = 0.95
)

iscambinomtest(
  observed = 0.14,
  n = 100,
  hypothesized = 0.20,
  alternative = "less"
)

iscambinomtest(observed = 17, n = 25, conf.level = 0.95)

iscambinomtest(observed = 12, n = 80, conf.level = c(0.90, 0.95, 0.99))
}
