% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phi_plot.R
\name{phiPlot}
\alias{phiPlot}
\title{Plot of phi versus y and boxplot of y}
\usage{
phiPlot(ds, phi.parms = NULL, limits = NULL, xlab = "y", ...)
}
\arguments{
\item{ds}{Dataset of y values}

\item{phi.parms}{The relevance function providing the data points where the pairs of values-relevance are known. Default is NULL}

\item{limits}{Vector with values to draw limits. Default is NULL}

\item{xlab}{Label of the x axis. Default is y}

\item{...}{Extra parameters when deriving the relevance function}
}
\value{
A line plot of phi versus y, as well as a boxplot of y
}
\description{
The phiPlot function uses a dataset ds containing many y values to produce a line plot of phi versus y and a boxplot of y, and aligns them, one above the other. The first extreme value on either side of the boxplot should correspond to the point where phi becomes exactly 1 on the line plot. This function is dependent on the robustbase, ggplot2 and ggpubr packages, and will not work without them.
}
\examples{
ds <- rnorm(1000, 30, 10); phi.parms <- phi.control(ds); phiPlot(ds,phi.parms)
ds <- rpois(100,3); phiPlot(ds)

}
