% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested_chart.R
\name{nested_chart}
\alias{nested_chart}
\title{Nested Chart}
\usage{
nested_chart(
  data,
  xarrows = NULL,
  subradius = 0,
  file_name = "none",
  size = 1,
  relative_scaling = 0,
  show_xarrows = FALSE,
  font = "sans",
  rotate_radians = 0,
  rotate_degrees = 0,
  subrotate_radians = 0,
  subrotate_degrees = 0,
  file_width = 10,
  file_height = 10,
  dpi = 500,
  color_global = "black",
  color_nested = "black",
  fade = 85,
  cor_spacing = 0,
  tick = 0,
  dist_construct_label = 10,
  rotate_construct_label_radians = 0,
  rotate_construct_label_degrees = 0,
  dist_test_labels = 2/3,
  rotate_test_labels_radians = 0,
  rotate_test_labels_degrees = 0,
  cor_labels_tests = TRUE,
  cor_labels_facets = TRUE,
  size_construct_label = 1,
  size_test_labels = 1,
  size_facet_labels = 1,
  width_axes = 1,
  width_axes_inner = 1,
  width_circles = 1,
  width_circles_inner = 1,
  width_tick = 1,
  width_tick_inner = 1,
  size_tick_label = 1,
  size_cor_labels = 1,
  size_cor_labels_inner = 1,
  width_xarrows = 1,
  size_xarrow_heads = 1,
  size_xarrow_labels = 1
)
}
\arguments{
\item{data}{SEM estimates in the appropriate format, given by the input
functions.}

\item{xarrows}{data frame containing information about additional correlation
arrows between facets of different tests; see examples.}

\item{subradius}{integer; same unit as center distances; radius of the facet
circles; defaults to 0, in which case an appropriate value is estimated.}

\item{file_name}{character; name of the file to save. Supported formats are:
"pdf" (highest quality and smallest file size), "png", "jpeg"; defaults to "none".}

\item{size}{integer; changes the size of most chart objects simultaneously.}

\item{relative_scaling}{integer; relative size of the global chart scale
compared to the nested facet chart scales; defaults to 0, in which case an
appropriate value is estimated.}

\item{show_xarrows}{logical; if \code{TRUE}, shows correlation arrows between
facets of different tests, according to xarrows.}

\item{font}{character; text font, use extrafonts to access additional fonts;
defaults to "sans", which is "Helvetica".}

\item{rotate_radians}{integer; radian angle to rotate the chart
counter-clockwise by; use fractions of pi (e.g. pi/2 = 90 degrees).}

\item{rotate_degrees}{integer; angle in degrees to rotate the chart
counter-clockwise by.}

\item{subrotate_radians}{integer; radian angle or vector of radian angles to
rotate the nested facet charts counter-clockwise by; use fractions of pi
(e.g. pi/2 = 90 degrees).}

\item{subrotate_degrees}{integer; angle or vector of angles in degrees to
rotate the nested facet charts counter-clockwise by.}

\item{file_width}{integer; file width in inches; defaults to 10.}

\item{file_height}{integer; file height in inches; defaults to 10.}

\item{dpi}{integer; resolution in dots per inch for "png" and "jpeg" files;
defaults to 500.}

\item{color_global}{global accent color; defaults to "black".}

\item{color_nested}{nested accent color; defaults to "black".}

\item{fade}{integer; brightness of the gray tones between 0 (black) and 100
(white) in steps of 1; defaults to 85.}

\item{cor_spacing}{integer; if \code{correlations = TRUE}: width of the ring,
the correlations between tests are drawn in; defaults to 0, in which case an
appropriate value is estimated.}

\item{tick}{numeric; axis tick position; defaults to 0, in which case an
appropriate value is estimated.}

\item{dist_construct_label}{integer; position of the construct label relative
to the surrounding circle; defaults to 10, in which case an appropriate
value is estimated; a value of .5 would position the label halfway between
the center and the surrounding circle.}

\item{rotate_construct_label_radians}{integer; radian angle to rotate the
construct label counter-clockwise by; use fractions of pi (e.g. pi/2 = 90
degrees).}

\item{rotate_construct_label_degrees}{integer; angle in degrees to rotate the
construct label counter-clockwise by.}

\item{dist_test_labels}{integer; position of the test labels relative to the
surrounding circle; defaults to 2/3, in which case the test labels are
displayed 2/3 of the way from the centers to the surrounding circles.}

\item{rotate_test_labels_radians}{integer; radian angle or vector of radian
angles to rotate the test labels counter-clockwise by; use fractions of pi
(e.g. pi/2 = 90 degrees).}

\item{rotate_test_labels_degrees}{integer; angle or vector of angle in degrees
to rotate the test labels counter-clockwise by.}

\item{cor_labels_tests}{logical; if \code{TRUE}, shows the correlations
between tests as text.}

\item{cor_labels_facets}{logical; if \code{TRUE}, shows the correlations
between facets as text.}

\item{size_construct_label}{integer; construct label font size relative to
default.}

\item{size_test_labels}{integer; test label font size relative to default.}

\item{size_facet_labels}{integer; facet label font size relative to default.}

\item{width_axes}{integer; global radial axis width relative to default.}

\item{width_axes_inner}{integer; nested radial axis width relative to default.}

\item{width_circles}{integer; global circle outline width relative to default.}

\item{width_circles_inner}{integer; nested circle outline width relative to
default.}

\item{width_tick}{integer; global axis tick line width relative to default.}

\item{width_tick_inner}{integer; nested axis tick line width relative to
default.}

\item{size_tick_label}{integer; axis tick label font size relative to default.}

\item{size_cor_labels}{integer; font size of the correlations between tests
relative to default.}

\item{size_cor_labels_inner}{integer; font size of the correlations between
facets relative to default.}

\item{width_xarrows}{integer; extra arrow line width relative to default.}

\item{size_xarrow_heads}{integer; extra arrow head length relative to default.}

\item{size_xarrow_labels}{integer; font size of the correlations indicated by
extra arrows relative to default.}
}
\value{
Object of the class "ggplot".
}
\description{
Creates a nested chart, showing several tests and their facets.
}
\details{
To get tidy results, it is often required to use \code{rotate_} and
 \code{subrotate_} for better alignment.

 If you set \code{subrotate_} to a single value, all nested facet charts will
 be rotated by the same amount. If you use a vector of values, the nested
 facet charts will be rotated one by one by the values from that vector.

 Increase \code{relative_scaling} to avoid circle overlap. Decrease it to
 make small chart objects more visible.

 \code{correlations} and \code{cor_spacing} add larger circles around the
 nested facet charts, but do not change these facet charts.

 When changing the size of objects, consider the \code{size} parameter first
 and make specific adjustments with the other \code{size_} and \code{width_}
 parameters after.

 Pdf files will be vector based and can be scaled arbitrarily. For other
 formats use \code{file_width}, \code{file_height}, and \code{dpi} to avoid
 later rescaling and loss of quality.
}
\examples{
# as simple as that
nested_chart(self_confidence, subradius = .6)

# adding xarrows, in this example for all cases where the correlation between
# facets exceeds the correlation between their respective tests.
sc_arrows <- data.frame(test1 = rep(NA, 3),
                        facet1 = NA,
                        test2 = NA,
                        facet2 = NA,
                        value = NA)
sc_arrows[1, ] <- c("DSSEI", "Ab", "RSES", "Ps", ".67")
sc_arrows[2, ] <- c("DSSEI", "Ab", "SMTQ", "Cs", ".81")
sc_arrows[3, ] <- c("SMTQ", "Ct", "RSES", "Ns", ".76")
nested_chart(self_confidence,
             subradius = .6,
             xarrows = sc_arrows,
             show_xarrows = TRUE)

# rotating the nested facet charts one by one
nested_chart(self_confidence,
             subradius = .6,
             subrotate_radians = c(0, pi / 2, 0))

# test without facets

global <- system.file("extdata", "IPV_global.xlsx", package = "IPV", mustWork = TRUE)
tests <- c(system.file("extdata", "IPV_DSSEI.xlsx", package = "IPV", mustWork = TRUE),
           system.file("extdata", "IPV_SMTQ.xlsx", package = "IPV", mustWork = TRUE),
           NA)
x <- input_excel(global = global, tests = tests)
nested_chart(x)

}
\seealso{
\code{\link{item_chart}} \code{\link{facet_chart}}
}
