\name{IPPPinterval}
\alias{IPPPinterval}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Simulate the Number of Events in an Interval
}
\description{
Generates random numbers that correspond to the number of events of an inhomogeneous Poisson point process (IPPP) in a given interval.

The IPPP is described by a rate function r.
}
\usage{
IPPPinterval(from, to, xrate, yrate, no = 1, expsamplesize = NULL)
}

\arguments{
  \item{from}{Real number, describing the lower boundary of the interval of interest}
  \item{to}{Real number larger than from, describing the upper boundary of the interval of interest}
  \item{xrate}{Vector of (strictly increasing) real numbers}
  \item{yrate}{Vector of positive real numbers of the same length as xrate. The vectors xrate and yrate form the rate function r in the sense that r=approxfun(xrate,yrate)}
  \item{no}{OPTIONAL, default is 1. The number of times the random number is determined}
  \item{expsamplesize}{OPTIONAL, default is NULL. Setting this parameter to a numeric value changes the average number of events generated by the IPPP as a whole to the chosen value. The number of events in the interval changes accordingly}
}
\details{Below min(xrate) and above max(xrate), the rate function r is assumed to have
the value zero.}
\value{
Vector of length no, whose i-th entry contains the number of events in the interval generated in the i-th run.
}

\author{Niklas Hohmann}

\references{
Hohmann, Niklas. "Conditional Densities and Simulations of Inhomogeneous Poisson Point Processes." arXiv 2019. <arXiv:1901.10754>}

\examples{
#determine rate function
sx=1:5
sy=c(0,1,1,3,0)
sm=c(1,0,1,0,-1)
xrate=seq(1,5,length.out=100)
yrate=splinefunH(sx,sy,sm)(xrate)
#plot rate function
plot(xrate,yrate,type='l',xlim=c(0.5,5.5), main='Rate Function') 
#determine no of events between 3 and 6
from=3
to=5
lines(c(from,from),c(0,10)) #mark interval in the plot
lines(c(to,to),c(0,10))
#simulate the number of events in the interval [from, to]
IPPPinterval(from,to,xrate,yrate) #simulate the number of events in the interval [from, to]
#rescale so that the whole rate function will on average generate 200 events:
IPPPinterval(from,to,xrate,yrate,expsamplesize=200)
#now more events occur in the interval [from, to]!
#Make 20 repetitions of the upper simulation
IPPPinterval(from,to,xrate,yrate,no=20,expsamplesize=200)
}

\keyword{ Poisson }
\keyword{ IPPP }