% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/produce_hr_report.R
\name{produce_hr_report}
\alias{produce_hr_report}
\title{Shortcut function with all steps to provide a Human Resources report}
\usage{
produce_hr_report(df, part = "all", format = "uploadable")
}
\arguments{
\item{df}{a dataframe set up according to the readme}

\item{part}{a string with what part of the report you want to produce "all", "A1", etc.}

\item{format}{A string (\code{"uploadable"} will produce a properly formatted
upload file. \code{"readable"} will produce a csv of the upload file (only
works for one part at a time). \code{"both"} will provide both options, but
only works with one part at a time.}
}
\value{
A txt or csv file at the path of your choice
}
\description{
Shortcut function with all steps to provide a Human Resources report
}
\examples{
\dontshow{
#set temp directory for this example (not necessary for users)
.old_wd <- setwd(tempdir())
}
\donttest{
#entire report
produce_hr_report(hr_staff)

#subsection with csv output instead of key-value txt
produce_hr_report(hr_staff, part = "A1", format = "readable")
}
\dontshow{
#reset directory for this example (not necessary for users)
setwd(.old_wd)
}
}
