% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDataSetList.R
\name{plot_eaf_data}
\alias{plot_eaf_data}
\title{Create EAF-based polygon plots}
\usage{
plot_eaf_data(
  df,
  maximization = F,
  scale.xlog = F,
  scale.ylog = F,
  scale.reverse = F,
  p = NULL,
  x_title = NULL,
  xmin = NULL,
  xmax = NULL,
  ymin = NULL,
  ymax = NULL,
  y_title = NULL,
  plot_title = NULL,
  subplot_attr = NULL,
  show.colorbar = F,
  subplot_shareX = F,
  dt_overlay = NULL,
  ...
)
}
\arguments{
\item{df}{The dataframe containing the data to plot. This should come from `generate_data.EAF`}

\item{maximization}{Whether the data comes from maximization or minimization}

\item{scale.xlog}{Logarithmic scaling of x-axis}

\item{scale.ylog}{Logarithmic scaling of y-axis}

\item{scale.reverse}{Decreasing or increasing x-axis}

\item{p}{A previously existing plot on which to add traces. If NULL, a new canvas is created}

\item{x_title}{Title of x-axis. Defaults to x_attr}

\item{xmin}{Minimum value for the x-axis}

\item{xmax}{Maximum value for the x-axis}

\item{ymin}{Minimum value for the y-axis}

\item{ymax}{Maximum value for the y-axis}

\item{y_title}{Title of x-axis. Defaults to x_attr}

\item{plot_title}{Title of x-axis. Defaults to no title}

\item{subplot_attr}{Which attribute of the dataframe to use for creating subplots}

\item{show.colorbar}{Whether or not to include a colorbar}

\item{subplot_shareX}{Whether or not to share X-axis when using subplots}

\item{dt_overlay}{Dataframe containing additional data (e.g. quantiles) to plot
on top of the EAF. This should have a column labeled 'runtime'. The other columsn will
all be plotted as function values.}

\item{...}{Additional parameters for the add_trace function}
}
\value{
An EAF plot
}
\description{
Create EAF-based polygon plots
}
\examples{
\dontrun{
plot_eaf_data(generate_data.EAF(subset(dsl, ID==get_id(dsl)[[1]])), maximization=T)
}
}
