% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_pred.R
\name{calc_pred}
\alias{calc_pred}
\title{Calculate predicted values and their confidence intervals for GAM(M)s}
\usage{
calc_pred(model_list, obs_press)
}
\arguments{
\item{model_list}{A list of model objects of class `gam` or `gamm`.}

\item{obs_press}{A list of vectors with pressure values (observed or an
artificial sequence).}
}
\value{
The function returns a tibble with one row for each model and three columns:
\describe{
  \item{\code{pred}}{A list-column with the predicted IND values
             given the input pressure values.}
  \item{\code{ci_up}}{A list-column with the upper 95\% confidence limit
             of the IND predictions.}
  \item{\code{ci_low}}{A list-column with the lower 95\% confidence limit
             of the IND predictions.}
}
}
\description{
\code{calc_pred} is a helper function for \code{\link{model_trend}},
\code{\link{model_gam}}, \code{\link{model_gamm}} and
\code{\link{plot_model}}. It calculates for a list of Generalized Additive
(Mixed) Models the predicted IND values as well as the upper and lower
95\% confidence intervals based on a list of corresponding
pressure values (observed or a regular spaced sequence).
}
\examples{
# Using the Baltic Sea demo data
model_list <- model_gam_ex$model
obs_press <- ind_init_ex$press_train
x <- calc_pred(model_list, obs_press)
}
\seealso{
\code{\link{model_trend}}, \code{\link{model_gam}},
\code{\link{model_gamm}}, \code{\link{plot_model}}
}
\keyword{internal}
