% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildfa.R
\name{build_fa}
\alias{build_fa}
\title{Build figural analogies.}
\usage{
build_fa(isomorphs = 1, main.rot = c(0, 0), mirror = 0, trap.rot = c(0,
  0), subtract = c(0, 0), dot.mov = c(0, 0), a.main = "R", a.flip = "R",
  a.trap = "R", a.dot = "R", constrict = F, al.main.rot = 0,
  al.mirror = 0, al.trap.rot = 0, al.subtract = 0, al.dot.mov = 0,
  correct = 0, add.rule = 0, automatic = T)
}
\arguments{
\item{isomorphs}{A number of isomorphic items to be developed.}

\item{main.rot}{A numeric vector with two main shape rotation values multiple of 45 and between -135 and 180. No rotation: 0.}

\item{mirror}{A number designating mirroring presence or no mirroring (i.e., 1 or 0).}

\item{trap.rot}{A numeric vector with two trapezium rotation values multiple of 45 and between -135 and 180. No rotation: 0.}

\item{subtract}{A numeric vector with two internal line subtractions from 1 to 5, or letter "R" for a random two-line subtraction. No subtraction: 0.}

\item{dot.mov}{A numeric vector with two dot edge movements from 1 to 6. No dot edge movement: 0.}

\item{a.main}{A number of rotation state of the main shape of Figure A from 1 to 8. Random by defect.}

\item{a.flip}{A number designating whether Figure A is flipped with respect to its vertical axis or not (i.e., 1 or 0). Random by defect.}

\item{a.trap}{A number of rotation state of the trapezium of Figure A from 1 to 8. Random by defect.}

\item{a.dot}{A number of dot edge position of Figure A from 1 to 6. Random by defect.}

\item{constrict}{Character string designating a part of Figure A to display all possible positions every 'n' isomorphs.}

\item{al.main.rot}{A numeric vector with alternative main shape rotation solutions. Random by defect.}

\item{al.mirror}{A numeric vector with alternative mirroring solutions. Random by defect.}

\item{al.trap.rot}{A numeric vector with alternative trapezium rotation solutions. Random by defect.}

\item{al.subtract}{A numeric vector with alternative subtraction solutions. Random by defect.}

\item{al.dot.mov}{A numeric vector with alternative dot edge movement solutions. Random by defect.}

\item{correct}{A number from 1 to 9 for correct response placement. Random by defect.}

\item{add.rule}{A number specifying which rule from 1 to 5 adds itself to the options of one-rule based items. Random by defect.}

\item{automatic}{Should options be generated by the program? True by defect.}
}
\value{
An object of class \code{'fa_items'}, basically a list including elements to be plotted with function \code{\link{plot_fa}}.
}
\description{
\code{build_fa} generates the information of figural analogies.
}
\details{
The argument \code{isomorphs} is the number of isomorphic
items to be created. The arguments \code{main.rot},
\code{mirror}, \code{trap.rot}, \code{subtract}, and
\code{dot.mov} are the so-called radical arguments.
They designate how rules are applied to all the isomorphs.
\code{main.rot} and \code{mirror} cannot be combined
because it is unpractical (Blum et al., 2016).
The arguments \code{a.main.rot}, \code{a.flip},
\code{a.trap}, and \code{a.dot} are the so-called
incidental arguments. They affect how the upper-left shape
of the main matrix (i.e., Figure A) presents itself in
every isomorph. Setting \code{constrict} to \code{"main"},
\code{"trap"} or \code{"dot"} displays all possible
positions of a certain part of Figure A (main shape,
trapezium or dot) every 'n' isomorphs.
Radical arguments that use the prefix \code{al.} designate
alternative solutions for each of the applied rules
throughout the options by following a Solutions Combination
Design (Blum et al., 2016). They are random by defect when
\code{automatic=T}. When \code{automatic=F}, values must be
chosen, which designate rotation angles between the correct
and the alternative solutions, or alternative mirroring /
subtraction / dot positions. Three things to keep in mind:
1. Three alternative solutions should be chosen for the
main rule when working with only one rule. If
\code{add.rule} is not altered, then all other rules should
also comprise one alternative solution each. If
\code{add.rule} designates a specific rule from 1 to 5,
then the latter statement is only valid for this rule.
2. Two alternative solutions should be chosen for each rule
of two rule-based items.
3. One alternative solution should be chosen for each rule
of items comprising more than two rules.
}
\examples{
\dontrun{Create two isomorphs with one rule, setting the correct answer to 1:}
one <- build_fa(isomorphs = 2, dot.mov = c(1, 2), correct = 1)
\dontrun{Plot them:}
plot_fa(one)

\dontrun{Create four isomorphs with two rules:}
two <- build_fa(isomorphs = 4, main.rot = c(180, 135), trap.rot = c(90, 45))
\dontrun{Plot them:}
plot_fa(two)

\dontrun{Create 20 isomorphs with three rules. Set \\code{automatic=F} and affect the options:}
three <- build_fa(isomorphs = 20, mirror = 1, trap.rot = c(90, 45), dot.mov = c(1, 2),
automatic = FALSE, al.mirror = c(0, 1), al.trap.rot = -45, al.dot.mov = 1)
\dontrun{Plot them:}
plot_fa(three)

\dontrun{Create and plot four two-rule based isomorphs, all of them comprising the same Figure A:}
four <- build_fa(isomorphs = 4, a.main = 1, a.flip = FALSE, a.trap = 2, a.dot = 6,
mirror = 1, subtract = "R")
plot_fa(four)

\dontrun{Create and plot 16 isomorphs by constricting the main shape rotation rule:}
five <- build_fa(isomorphs = 16, subtract = c(1, 4), constrict = "main")
plot_fa(five)
}
\author{
Diego Blum \email{<blumworx@gmail.com>}
}
\references{
Blum, D., Holling, H., Galibert, M.S., & Forthmann, B. (2016, in review). Task difficulty prediction of figural analogies. \emph{Intelligence}.
}
\seealso{
\code{\link{IMak}}
}

