% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LossSource.R
\name{LossSource}
\alias{LossSource}
\title{Obtaining indices associated with sources of loss}
\usage{
LossSource(DataLoss,DataResult,Cols=c(1,3,5),verbose)
}
\arguments{
\item{DataLoss}{It is an matrix object containing data from loss sources.}

\item{DataResult}{Matrix with loss sources.}

\item{Cols}{Most important data loss columns.}

\item{verbose}{Logical value (TRUE/FALSE). TRUE displays the results of the analysis.}
}
\value{
The function returns several indices associated with the loss source.
}
\description{
These functions allow to calculate the total n of the L.S. (n),
R.P., ks, c, ds, n.I.I., Sum.n.I.I., and percentage of I.I. (P.I.I.) by each L.S..\cr
Equations:
R.P. = Damage or defoliation \cr
n=total n per sample \cr
k.s.= R.P./n \cr
c = SUM of occurrence of L.S. on the samples, where, absence = 0 or presence = 1.\cr
ds = 1 - P of the chi-square test of L.S. on the samples.\cr
n.I.I.=ks x c x ds \cr
Sum.n.I.I. = sum of all n.I.I.\cr
Percentage of I.I. (P.I.I.)=(n.I.I. of each L.S./sum of all n.I.I.)*100
}
\examples{
data("DataLossSource")
ChisqTest_Distribution(DataLossSource)

data("DataSolutionSource")
ChisqTest_Distribution(DataSolutionSource)

data("DataDefoliation")
data("DataDamage")

DataResult=cbind(DataDefoliation,DataDamage$D.L.S.2,DataDefoliation,
DataDamage$D.L.S.4,DataDefoliation)
ResultLossSource=LossSource(DataLoss = DataLossSource,DataResult =DataResult,
Cols=c(1,3,5),verbose=TRUE)

EOS=EffectivenessOfSolution(DataLossSource =DataLossSource,
                            DataSolutionSource =DataSolutionSource,
                            ResultLossSource = ResultLossSource)

EOS
#Put: y and y
# ID=SelectEffectivenessOfSolution(EOS)
ID=c(FALSE,FALSE,FALSE,TRUE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,
FALSE,FALSE,FALSE,TRUE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE)
ResultSolutionSource=SolutionSource(SolutionData =DataSolutionSource,Production =DataResult,
                                    EffectivenessOfSolution =EOS ,Id = ID,Verbose = TRUE  )
ResultSolutionSource

# Put: y,n,y,n,y,n and y
# ReductionAbundance(ResultSolutionSource,ResultLossSource,
#                  EffectivenessOfSolution=EOS)

###################################################
EOSDamage=EffectivenessOfSolution(DataLossSource =DataDamage,
                                  DataSolutionSource =DataSolutionSource,
                                  ResultLossSource = NULL)


EOSDamage

# Put: y, n and y
#ReductionDamage(ResultSolutionSource,LossSource=DataDamage,
#                EffectivenessOfSolution=EOSDamage)

}
\seealso{
\code{\link{EffectivenessOfSolution}} ,  \code{\link{SolutionSource}}
}
\author{
Germano Leao Demolin-Leite (Instituto de Ciencias Agrarias da UFMG) \cr
Alcinei Mistico Azevedo (Instituto de Ciencias Agrarias da UFMG)
}
