% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popsGetObjecstIds.R
\name{popsGetObjectsIds}
\alias{popsGetObjectsIds}
\title{IFC_pops Object Numbers}
\usage{
popsGetObjectsIds(obj, pop = "")
}
\arguments{
\item{obj}{an `IFC_data` object extracted with features extracted.}

\item{pop}{a population name from 'obj'. Default is "".
If left as is or not found an error is thrown displaying all available population in 'obj'.}
}
\value{
An integer vector is returned
}
\description{
Retrieves objects ids belonging to a population.
}
\examples{
if(requireNamespace("IFCdata", quietly = TRUE)) {
  ## use a daf file
  file_daf <- system.file("extdata", "example.daf", package = "IFCdata")
  daf <- ExtractFromDAF(fileName = file_daf)
  obj <- popsGetObjectsIds(obj = daf, pop = names(daf$pops)[length(daf$pops)])
} else {
  message(sprintf('Please run `install.packages("IFCdata", repos = "\%s", type = "source")` \%s',
                  'https://gitdemont.github.io/IFCdata/',
                  'to install extra files required to run this example.'))
}
}
