IPA_workflow <- function(spreadsheet) {
  ##
  tryCatch(stop(""), error = function(e) {""}) # To clear cache of error messages
  on.exit({
    sillyErrors <- c("",
                     "subscript out of bounds",
                     "StopIteration", # StopIteration is generated by `foreach`
                     "cannot shut down device 1 (the null device)") # error by `dev.off()`
    ##
    errorMessages <- geterrmessage()
    xSillyErrors <- which(!(errorMessages %in% sillyErrors))
    if (length(xSillyErrors) > 0) {
      IPA_logRecorder(errorMessages[xSillyErrors])
      IPA_logRecorder("Stopped IDSL.IPA workflow!")
    }
    ##
    if (exists('.logIPA')) {
      rm(.logIPA, envir = .GlobalEnv)
    }
  })
  ##
  initiation_time <- Sys.time()
  ##
  gc()
  closeAllConnections()
  ##############################################################################
  PARAM <- IPA_xlsxAnalyzer(spreadsheet)
  if (!is.null(PARAM)) {
    ##
    timeZone <- tryCatch(Sys.timezone(), warning = function(w) {"UTC"}, error = function(e) {"UTC"})
    ##
    if (tolower(PARAM[which(PARAM[, 1] == 'PARAM0005'), 2]) == "no") {
      ##
      ##########################################################################
      ## To create log record for IDSL.IPA
      input_path <- PARAM[which(PARAM[, 1] == 'PARAM0007'), 2]
      output_path <- PARAM[which(PARAM[, 1] == 'PARAM0010'), 2]
      .GlobalEnv$.logIPA <- paste0(output_path, "/logIPA_performance.txt")
      IPA_logRecorder(paste0(rep("", 100), collapse = "="))
      IPA_logRecorder("Type <<< citation('IDSL.IPA') >>> for citing this R package in publications.")
      IPA_logRecorder(paste0("mzML/mzXML/netCDF:  ", input_path))
      IPA_logRecorder(paste0("OUTPUT:  ", output_path))
      IPA_logRecorder(paste0(rep("", 100), collapse = "-"))
      IPA_logRecorder("Initiated IDSL.IPA workflow!")
      IPA_logRecorder(paste0(as.character(initiation_time), " ", timeZone))
      IPA_logRecorder("", printMessage = FALSE)
      IPA_logRecorder("", printMessage = FALSE)
      IPA_logRecorder(paste0(PARAM[, 1], "\t", PARAM[, 2]),  printMessage = FALSE)
      IPA_logRecorder(paste0(rep("", 100), collapse = "-"))
      ##
      ##########################################################################
      ##
      if (tolower(PARAM[which(PARAM[, 1] == 'PARAM0001'), 2]) == "yes") {
        IPA_PeakAnalyzer(PARAM)
      }
      if (tolower(PARAM[which(PARAM[, 1] == 'PARAM0002'), 2]) == "yes") {
        IPA_PeakAlignment(PARAM)
      } else {
        x0004 <- PARAM[which(PARAM[, 1] == 'PARAM0004'), 2]
        x0045 <- PARAM[which(PARAM[, 1] == 'PARAM0045'), 2]
        if (!is.na(x0004) & !is.na(x0045)) {
          if (tolower(x0004) == "yes" & tolower(x0045) == "yes") {
            IPA_PeakAlignment(PARAM)
          }
        }
      }
      if (tolower(PARAM[which(PARAM[, 1] == 'PARAM0003'), 2]) == "yes") {
        IPA_GapFiller(PARAM)
      }
      if (tolower(PARAM[which(PARAM[, 1] == 'PARAM0004'), 2]) == "yes") {
        if (tolower(PARAM[which(PARAM[, 1] == 'PARAM0046'), 2]) == "yes") {
          IPA_CompoundsAnnotation(PARAM)
        }
        if (tolower(PARAM[which(PARAM[, 1] == 'PARAM0047'), 2]) == "yes") {
          IPA_PeaklistAnnotation(PARAM)
        }
      }
      ##
    } else {
      PARAM_targeted <- IPA_targeted_xlsxAnalyzer(spreadsheet)
      if (!is.null(PARAM_targeted)) {
        ##
        ########################################################################
        ## To create log record for IDSL.IPA
        input_path <- PARAM_targeted[which(PARAM_targeted[, 1] == 'PARAM0007'), 2]
        output_path <- PARAM_targeted[which(PARAM_targeted[, 1] == 'PARAM0010'), 2]
        .GlobalEnv$.logIPA <- paste0(output_path, "/logIPA_targeted.txt")
        IPA_logRecorder(paste0(rep("", 100), collapse = "="))
        IPA_logRecorder("Type <<< citation('IDSL.IPA') >>> for citing this R package in publications.")
        IPA_logRecorder(paste0("mzML/mzXML/netCDF:  ", input_path))
        IPA_logRecorder(paste0("OUTPUT:  ", output_path))
        IPA_logRecorder(paste0(rep("", 100), collapse = "-"))
        IPA_logRecorder("Initiated the IPA targeted analysis!")
        IPA_logRecorder(paste0(as.character(initiation_time), " ", timeZone))
        IPA_logRecorder("", printMessage = FALSE)
        IPA_logRecorder("", printMessage = FALSE)
        IPA_logRecorder(paste0(PARAM_targeted[, 1], "\t", PARAM_targeted[, 2]),  printMessage = FALSE)
        IPA_logRecorder(paste0(rep("", 100), collapse = "-"))
        ##
        ########################################################################
        ##
        exportTableCheck <- TRUE
        PARAM_CCT <- tolower(PARAM_targeted[which(PARAM_targeted[, 1] == 'PARAM_CCT'), 2])
        if (PARAM_CCT == "n" | PARAM_CCT == "no") {
          exportTableCheck <- FALSE
        }
        ##
        ########################################################################
        ##
        IPA_TargetedTable <- IPA_targeted(PARAM_targeted)
        ##
        ########################################################################
        ##
        if (exportTableCheck) {
          save(IPA_TargetedTable, file = paste0(output_path, "/IPA_TargetedTable.Rdata"))
          write.csv(IPA_TargetedTable, file = paste0(output_path, "/IPA_TargetedTable.csv"), row.names = TRUE)
          IPA_logRecorder(paste0("Targeted peaklists are stored in `.Rdata` and `.csv` formats in the `", output_path,"` folder!"))
        }
        ##
        IPA_logRecorder("Completed the IPA targeted analysis!")
        IPA_logRecorder(paste0(rep("", 100), collapse = "-"))
      }
    }
    ##
    ############################################################################
    ##
    completion_time <- Sys.time()
    IPA_logRecorder(paste0(rep("", 100), collapse = "-"))
    required_time <- completion_time - initiation_time
    IPA_logRecorder(paste0("The required processing time was `", required_time, " ", attributes(required_time)$units, "`"))
    IPA_logRecorder(paste0(as.character(completion_time), " ", timeZone), printMessage = FALSE)
    IPA_logRecorder("", printMessage = FALSE)
    IPA_logRecorder("", printMessage = FALSE)
    IPA_logRecorder("Completed IDSL.IPA computations successfully!")
    IPA_logRecorder(paste0(rep("", 100), collapse = "="), printMessage = FALSE)
    ##
    ############################################################################
    ##
  }
  ##
  gc()
  closeAllConnections()
  ##
}
##
IPA_Workflow <- function(spreadsheet) {
  IPA_workflow(spreadsheet)
}
