% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gevdfit.R
\name{gev.d.lik}
\alias{gev.d.lik}
\title{d-GEV Likelihood}
\usage{
gev.d.lik(
  xdat,
  ds,
  mut,
  sigma0,
  xi,
  theta,
  eta,
  log = FALSE,
  tau = 0,
  eta2 = 0
)
}
\arguments{
\item{xdat}{numeric vector containing observations}

\item{ds}{numeric vector containing corresponding durations (1/60 corresponds to 1 minute, 1 corresponds to 1 hour)}

\item{mut, sigma0, xi, theta, eta, eta2, tau}{numeric vectors containing corresponding estimates for each of the parameters}

\item{log}{Logical; if TRUE, the log likelihood is returned.}
}
\value{
single value containing (log) likelihood
}
\description{
Computes (log-) likelihood of d-GEV model
}
\examples{
# compute log-likelihood of observation values not included in fit
train.set <- example[example$d!=2,]
test.set <- example[example$d==2,]
fit <- gev.d.fit(train.set$dat,train.set$d,mutl = c(1,2),sigma0l = 1
          ,ydat = as.matrix(train.set[c('cov1','cov2')]))
params <- gev.d.params(fit,ydat = as.matrix(test.set[c('cov1','cov2')]))
gev.d.lik(xdat = test.set$dat,ds = test.set$d,mut = params[,1],sigma0 = params[,2],xi = params[,3]
          ,theta = params[,4],eta = params[,5],log=TRUE)
}
