% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICSKATwrapper.R
\name{ICSKATwrapper}
\alias{ICSKATwrapper}
\title{ICSKATwrapper.R}
\usage{
ICSKATwrapper(
  left_dmat,
  right_dmat,
  initValues,
  lt,
  rt,
  obs_ind,
  tpos_ind,
  gMat,
  PH = TRUE,
  nKnots = 1,
  maxIter = 3,
  eps = 10^(-6),
  runOnce = FALSE,
  returnNull = FALSE
)
}
\arguments{
\item{left_dmat}{n*(p+nknots+2) design matrix for left end of interval.}

\item{right_dmat}{n*(p+nknots+2) design matrix for right end of interval.}

\item{initValues}{(p+nknots+2)*1 vector of coefficients to initialize the Newton-Raphson.}

\item{lt}{Left side of interval times.}

\item{rt}{Right side of interval times.}

\item{obs_ind}{n*1 vector of whether the event was observed before last follow-up.}

\item{tpos_ind}{n*1 vector of whether the event was observed after follow-up started (t>0).}

\item{gMat}{n*q matrix of genotypes.}

\item{PH}{Boolean for whether to fit PH model (TRUE) or PO model (FALSE).}

\item{nKnots}{Number of knots in the spline.}

\item{maxIter}{Number of times to try the fit if initial values do not lead to convergence.}

\item{eps}{Difference in L2 norm of fitted null coefficients that stops the Newton Raphson.}

\item{runOnce}{Boolean, if true then just go through the algorithm once with the initial
values for coefficients, updating the variance matrix, useful for bootstrapping.}

\item{returnNull}{Return a list with the skat output and null model, or just return the skat output (FALSE).}
}
\value{
Either a list with skatOutput and nullFit (two lists), or just skatOutput.
}
\description{
Wrapper to fit the null model and run ICSKAT all in one instead of separately - offers some functionality
for error checking or using different initial values when fit fails to converge.
}
\examples{
set.seed(0)
gMat <- matrix(data=rbinom(n=2000, size=2, prob=0.3), nrow=100)
xMat <- matrix(data=rnorm(200), nrow=100)
bhFunInv <- function(x) {x}
obsTimes <- 1:5
etaVec <- rep(0, 100)
outcomeDat <- gen_IC_data(bhFunInv = bhFunInv, obsTimes = obsTimes, windowHalf = 0.1,
probMiss = 0.1, etaVec = etaVec)
lt <- outcomeDat$leftTimes
rt <- outcomeDat$rightTimes
tpos_ind <- as.numeric(lt > 0)
obs_ind <- as.numeric(rt != Inf)
dmats <- make_IC_dmat(xMat, lt, rt, obs_ind, tpos_ind)
ICSKATwrapper(left_dmat = dmats$left_dmat, right_dmat = dmats$right_dmat,
initValues = rep(0, ncol(xMat) + 3), lt = lt, rt = rt, obs_ind = obs_ind,
tpos_ind = tpos_ind, gMat = gMat, returnNull = TRUE)

}
