% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getp.R
\name{getMethp}
\alias{getMethp}
\title{getMethp}
\usage{
getMethp(meth_data, label, p.adjust = TRUE, method = "fdr")
}
\arguments{
\item{meth_data}{A data frame, the Methylation profile to calculate p-value for each gene, the rownames should be the symbol of genes.}

\item{label}{label A vector of 0/1s, indicating the class of samples in the Methylation profile, 0 represents case, 1 represents control.}

\item{p.adjust}{Logical,tell if returns corrected p-values}

\item{method}{Correction method,which can be one of "holm", "hochberg", "hommel", "bonferroni", "BH", "BY",}
}
\value{
A numeric vector of p-values or corrected p-values
}
\description{
\code{getMethp} perform t-test on Methylation profile data
}
\details{
For a given Methylation profile of two conditions, ICDS package provide t-test method to calculate p-values or corrected p-values(if p.adjust=TRUE,return corrected p-values,if p.adjust=FALSE,return p-values.) for each genes. The row of the Methylation profile should be gene symbols and the column of the Methylation profile should be names of samples. Samples should be under two conditions and the label should be given as 0 and 1.
}
\examples{
profile<-GetExampleData("meth_data")
label<-GetExampleData("label2")
\dontrun{getMethp(profile,label,p.adjust=FALSE)}
}
