\name{reqHistoricalData}
\alias{reqHistoricalData}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Request Historical Data From TWS }
\description{
Makes a request to the Interactive Brokers Trader Workstation (TWS),
and returns an xts object containing the results of the request
if successful.
}
\usage{
reqHistoricalData(conn, 
                  Contract,
                  endDateTime,
                  barSize = "1 day",
                  duration = "1 M",
                  useRTH = "1",
                  whatToShow = "TRADES", 
                  time.format = "1")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{conn}{ a \code{tws} connection object }
  \item{Contract}{ a \code{twsContract} }
  \item{endDateTime}{ end date/time for request. See details. }
  \item{barSize}{ bar size to retrieve }
  \item{duration}{ time span the request will cover }
  \item{useRTH}{ limited to regular trading hours }
  \item{whatToShow}{ type of data to be extracted }
  \item{time.format}{ POSIX style or seconds from 1970-01-01 }
}
\details{
All arguments should be character strings.  Attempts will
be made to coerce, but should not be relied upon.

The \code{endDateTime} argument must be of the form
'CCYYMMDD HH:MM:SS TZ'. If not specified the current
time as returned from the TWS server will be used. This
is the preferred method.

Legal \code{barSize} settings are technically
\sQuote{1 secs},\sQuote{5 secs},\sQuote{15 secs},
\sQuote{30 mins},\sQuote{1 min},\sQuote{2 mins},
\sQuote{3 mins},\sQuote{5 mins},\sQuote{15 mins},
\sQuote{30 mins},\sQuote{1 hour},\sQuote{1 day},
\sQuote{1 week},\sQuote{1 month},\sQuote{3 months},
and \sQuote{1 year}. They must be specified exactly
and there is no guarantee from the API that all
will work for all securities or durations. 

The duration string must be of the form \sQuote{n S}
where the last character may be any one of
\sQuote{S} (seconds),
\sQuote{D} (days),
\sQuote{W} (weeks),
\sQuote{M} (months),
and \sQuote{Y} (year).
At present the limit for years is 1.

\code{useRTH} takes either \sQuote{1} or \sQuote{0},
indicating the request to return only regular trade
hour data, or all data, respectively.

\code{whatToShow} can be any one of the following,
though depending on the overall request it may not succeed.
\sQuote{TRADES}, \sQuote{MIDPOINT}, \sQuote{BID},
\sQuote{ASK}, \sQuote{BID/ASK}.

\code{time.format} should simply be left alone. :D

}
\value{
Returns an \code{xts} object containing the requested data, along
with additional information stored in the objects \code{xtsAttributes}.
}
\references{ Interactive Brokers \url{www.interactivebrokers.com} }
\author{ Jeffrey A. Ryan }
\note{
There is a strictly enforced 6 seconds between request pacing rule
implemented by the TWS. Keep this in mind.

The TWS workstation must be running on the same machine
as \R.

The TWS must also be set up to allow for the API to be connected
to.  See the associated help on the main Interactive Brokers
website.

The underlying API is subject to changes on an ongoing basis by
Interactive Brokers.  All attempts have been made to keep this
current.  If something should fail, please contact the maintainer
of this package.
}
\seealso{ \code{\link{twsContract}}, \code{\link{twsConnect}} }
\examples{
\dontrun{
tws <- twsConnect()
contract <- twsEquity('QQQQ','SMART','ISLAND')

reqHistoricalData(tws,Contract=contract)
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ utilities }
