# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Death table
#'
#' @name death_table
#'
#' @description Creates a death table from a population data frame.
#' For each \code{i=1..N-1} and \code{j=1..M}, the number of individuals with age at last birthday in \code{[ages[i],ages[i+1])} and died in \code{[times[j],times[j+1])} is computed.
#'
#' @param pop_df Population data frame containing at least \code{'birth'} and \code{'death'} columns.
#' @param ages A vector of size \code{N} composed of age groups.
#' @param period A vector of size \code{M} composed of time intervals.
#'
#' @details The function computes the number of death in each time interval \code{[times[j],times[j+1])}, \code{j=1..M}.
#'
#' @return A death table matrix.
#'
#' @examples
#' dth_table <-  death_table(EW_pop_out, 0:101, 0:31)
#'
#' @export
death_table <- function(pop_df, ages, period) {
    .Call(`_IBMPopSim_death_table`, pop_df, ages, period)
}

#' Exposure table
#'
#' @name exposure_table
#'
#' @description  Returns the Central Exposure-to-Risk for given ages groups and time period.
#' The central Exposure-to-risk is computed as the sum of the time spent by individuals in a given age group over a given period, where age is the age at last birthday.
#'
#' @inheritParams death_table
#'
#' @details The function computes the central exposure-to-risk in each time interval \code{[t[j],t[j+1])}, \code{j=1..M}, and age groups.
#'
#' @return An exposure matrix
#'
#' @examples
#' ex_table <- exposure_table(EW_pop_out,0:101,0:2)
#'
#' @export
exposure_table <- function(pop_df, ages, period) {
    .Call(`_IBMPopSim_exposure_table`, pop_df, ages, period)
}

