% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hydro3Stats.R
\name{GetQfromT}
\alias{GetQfromT}
\title{Get quantile from return period}
\usage{
GetQfromT(RP, H3, options = options_def)
}
\arguments{
\item{RP}{numeric, return period}

\item{H3}{list, resulting from a call to Hydro3_Estimation()}

\item{options}{list, see ?Hydro3_Estimation}
}
\value{
A list with the following components:
    \item{q}{numeric, quantile}
    \item{IC}{numeric vector, uncertainty interval}
}
\description{
Compute the T-quantile from the results of Hydro3_Estimation()
}
\examples{
y=stats::rnorm(50)
H3=Hydro3_Estimation(y,'Normal')
GetQfromT(100,H3)
}
