% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bindPosterior.R
\name{bindPosterior}
\alias{bindPosterior}
\title{Bind Posterior Distributions}
\usage{
bindPosterior(hydePost, relabel_factor = TRUE)
}
\arguments{
\item{hydePost}{An object of class \code{HydePosterior}}

\item{relabel_factor}{Logical.  If \code{TRUE}, factors that had been
  converted to integers for the JAGS code can be relabelled as factors
  for additional analysis in R.}
}
\description{
After determining the posterior distributions are satisfactory,
  it can be advantageous to bind the posterior distributions together in
  order to aggregate values and perform other manipulations and analyses.
}
\details{
For the purposes of this function, it is assumed that if the
  posterior distributions are satisfactory, the multiple chains in a run
  can be bound together.  Subsequently, the multiple runs are bound
  together.  Lastly, the factors are relabeled, if requested.
}
\examples{
#' data(PE, package="HydeNet")
Net <- HydeNetwork(~ wells +
                     pe | wells +
                     d.dimer | pregnant*pe +
                     angio | pe +
                     treat | d.dimer*angio +
                     death | pe*treat,
                     data = PE)


compiledNet <- compileJagsModel(Net, n.chains=5)

#* Generate the posterior distribution
Posterior <- HydePosterior(compiledNet,
                           variable.names = c("d.dimer", "death"),
                           n.iter=1000)

Bound <- bindPosterior(Posterior)

#* Bind a Decision Network
#* Note: angio shouldn't really be a decision node.
#*       We use it here for illustration
Net <- setDecisionNodes(Net, angio, treat)
compiledDecision <- compileDecisionModel(Net, n.chains=5)
PosteriorDecision <- HydePosterior(compiledDecision,
                                   variable.names = c("d.dimer", "death"),
                                   n.iter = 1000)
}
\author{
Jarrod Dalton and Benjamin Nutter
}

