% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_annual_stat_trend.R
\name{calc_annual_stat_trend}
\alias{calc_annual_stat_trend}
\title{Calculate trend in annual statistics}
\usage{
calc_annual_stat_trend(data = NULL, year, value, ...)
}
\arguments{
\item{data}{'data.frame'. Optional data.frame input, with columns containing \code{year} and \code{value}.
Column names are specified as strings in the corresponding parameter. Default is \code{NULL}.}

\item{year}{'numeric' vector when \code{data = NULL}, or 'character' string identifying year column
name when \code{data} is specified. Year of each value in \code{value} parameter.}

\item{value}{'numeric' vector when \code{data = NULL}, or 'character' string identifying value column
name when \code{data} is specified. Values to calculate trend on.}

\item{...}{further arguments to be passed to or from \code{\link[EnvStats:kendallTrendTest]{EnvStats::kendallTrendTest}}.}
}
\value{
A tibble (see \code{\link[tibble:tibble]{tibble::tibble}}) with test statistic, p-value, trend coefficients, and
trend calculations. See \strong{Details}.
}
\description{
Calculate trend in annual statistics
}
\details{
This function is a wrapper for \code{\link[EnvStats:kendallTrendTest]{EnvStats::kendallTrendTest}} with the passed equation
\code{value ~ year}. The returned values include Mann-Kendall test statistic and p-value,
Theil-Sen slope and intercept values, and trend details (Millard, 2013; Helsel and others, 2020).
\describe{
\item{\code{z_stat}}{Mann-Kendall test statistic, returned directly from
\code{\link[EnvStats:kendallTrendTest]{EnvStats::kendallTrendTest}}}
\item{\code{p_value}}{\code{z_stat} p-value, returned directly from
\code{\link[EnvStats:kendallTrendTest]{EnvStats::kendallTrendTest}}}
\item{\code{sen_slope}}{Sen slope in units value per year, returned directly from
\code{\link[EnvStats:kendallTrendTest]{EnvStats::kendallTrendTest}}}
\item{\code{intercept}}{Sen slope intercept, returned directly from \code{\link[EnvStats:kendallTrendTest]{EnvStats::kendallTrendTest}}}
\item{\code{trend_mag}}{Trend magnitude over entire period, in units of \code{value},
calculated as \verb{sen_slope * (max(year)} \eqn{-} \verb{min(year))}}
\item{\code{val_beg/end}}{Calculated value at beginning or end of period, calculated as
\code{sen_slope * year + intercept}}
\item{\code{val_perc_change}}{Percentage change over period, calculated as
\code{(val_end - val_beg) / val_beg * 100}}
}
}
\examples{
calc_annual_stat_trend(data = example_annual, year = "WY", value = "annual_mean")

}
\references{
Millard, S.P., 2013, EnvStats: An R Package for Environmental Statistics: New York, New York,
Springer, 291 p. [Also available at https://doi.org/10.1007/978-1-4614-8456-1.]

Helsel, D.R., Hirsch, R.M., Ryberg, K.R., Archfield, S.A., and Gilroy, E.J., 2020, Statistical
methods in water resources: U.S. Geological Survey Techniques and Methods, book 4, chap. A3, 458
p. [Also available at https://doi.org/10.3133/tm4a3.]
}
\seealso{
\code{\link[EnvStats]{kendallTrendTest}}
}
\keyword{annual-statistics}
\keyword{trends}
