% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructGradient.R
\name{constructGradient}
\alias{constructGradient}
\title{constructGradient}
\usage{
constructGradient(hM, focalVariable, non.focalVariables = list(), ngrid = 20)
}
\arguments{
\item{hM}{a fitted \code{Hmsc} model object}

\item{focalVariable}{focal variable over which the gradient is constructed}

\item{non.focalVariables}{list giving assumptions on how non-focal variables co-vary with the focal variable or a single number given the default type for all non-focal variables}

\item{ngrid}{number of points along the gradient (for continuous focal variables)}
}
\value{
a named list with slots \code{XDataNew}, \code{studyDesignNew} and \code{rLNew}
}
\description{
Constructs an environmental gradient over one of the variables included in \code{XData}
}
\details{
In basic form, \code{non.focalVariables} is a list, where each element is on the form variable=list(type,value),
where \code{variable} is one of the non-focal variables, and the \code{value} is needed only if \code{type = 3}. Alternatives
\code{type = 1} sets the values of the non-focal variable
to the most likely value (defined as expected value for covariates, mode for factors),
\code{type = 2} sets the values of the non-focal variable to most likely value, given the value of focal variable,
based on a linear relationship, and
\code{type = 3} fixes to the value given.
As a shortcut, a single number \code{1} or \code{2} can be given as a type
used for all non-focal variables.
If a \code{non.focalVariable} is not listed, \code{type=2} is used as default.
Note that if the focal variable is continuous, selecting type 2 for a non-focal categorical variable can cause abrupt changes in response.
}
\examples{
# Construct gradient for environmental covariate called 'x1'.
Gradient = constructGradient(TD$m, focalVariable="x1")

# Construct gradient for environmental covariate called 'x1'
# while setting the other covariate to its most likely values
Gradient = constructGradient(TD$m, focalVariable="x1",non.focalVariables=list(x2=list(1)))

}
\seealso{
\code{\link{plotGradient}}, \code{\link{predict}}.
}
