lasso_d <- function(x,lambda,a=3){

  ## -----------------------------------------------------------------------------------------------------------------
  ## The name of the function: lasso_d
  ## -----------------------------------------------------------------------------------------------------------------
  ## Description:
  ##            Calculating the derivative of the lasso
  ## -----------------------------------------------------------------------------------------------------------------
  ## Required preceding functions or packages: No
  ## -----------------------------------------------------------------------------------------------------------------
  ## Input:
  ## @ x: a float value or a vector, the independent variable in the lasso.
  ## @ lambda: a float value, the tuning parameter in the MCP.
  ## -----------------------------------------------------------------------------------------------------------------
  ## Output:
  ## @ rho: the derivative of the lasso.
  ## -----------------------------------------------------------------------------------------------------------------

  if(lambda!=0){
    rho <- a/a * lambda * (abs(x) > 0)
  } else{
    rho=0
  }
  return(rho)
}
