% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.LD50.R
\name{plot.LD50}
\alias{plot.LD50}
\title{Plot results of LD50() that best describe LD50}
\usage{
\method{plot}{LD50}(
  x,
  ...,
  las.x = 1,
  las.y = 1,
  lab.PT = "LD50",
  at = NULL,
  lab.TRD = paste0("Transitional range of doses l=", l * 100, "\%"),
  col.TRD = "gray",
  col.TRD.CI = rgb(0.8, 0.8, 0.8, 0.5),
  col.PT.CI = rgb(0.8, 0.8, 0.8, 0.5),
  show.CI = TRUE
)
}
\arguments{
\item{x}{A result file generated by IC50()}

\item{...}{Parameters for plot()}

\item{las.x}{las parameter for x axis}

\item{las.y}{las parameter for y axis}

\item{lab.PT}{Label to describe pivotal dose}

\item{at}{Position of ticks in x-axis}

\item{lab.TRD}{Label to describe transitional range of dose}

\item{col.TRD}{The color of TRD}

\item{col.TRD.CI}{The color of CI of TRD based on range.CI}

\item{col.PT.CI}{The color of CI of PT based on range.CI}

\item{show.CI}{Do the CI for the curve should be shown}
}
\value{
Nothing
}
\description{
Plot the estimates that best describe lethality of doses.
}
\details{
plot.LD50 plot result of IC50() that best describe IC50
}
\examples{
\dontrun{
data <- data.frame(Doses=c(80, 120, 150, 150, 180, 200),
Alive=c(10, 12, 8, 6, 2, 1),
Dead=c(0, 1, 5, 6, 9, 15))
LD50_logistic <- LD50(data, equation="logistic")
predict(LD50_logistic, doses=c(140, 170))
plot(LD50_logistic, xlim=c(0, 300))
}
}
\seealso{
Other LD50 functions: 
\code{\link{LD50_MHmcmc_p}()},
\code{\link{LD50_MHmcmc}()},
\code{\link{LD50}()},
\code{\link{logLik.LD50}()},
\code{\link{predict.LD50}()}
}
\author{
Marc Girondot
}
\concept{LD50 functions}
