% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.IconoCorel.R
\name{plot.IconoCorel}
\alias{plot.IconoCorel}
\title{Clean the dataframe before to be used with IC_threshold_matrix}
\usage{
\method{plot}{IconoCorel}(x, ..., show.legend.direction = "bottomright",
  show.legend.strength = "topleft", title = "Correlation iconography",
  vertex.label.color = "black", vertex.label = NULL,
  vertex.color = "white", plot = TRUE)
}
\arguments{
\item{x}{The correlation matrix to show}

\item{...}{other options of plot.igraph()}

\item{show.legend.direction}{the position of the legend of direction; FALSE to not show it}

\item{show.legend.strength}{the position of the legend with intensity of correlation; FALSE to not show it}

\item{title}{the title of the plot}

\item{vertex.label.color}{a vector with the colors of labels}

\item{vertex.label}{a vector with the labels}

\item{vertex.color}{a vector of colors}

\item{plot}{if TRUE, the plot is shown}
}
\value{
A igraph object
}
\description{
This function plots the data as a network. It returns an invisible object that can be used with visIgraph from package visNetwork.
\code{https://fr.wikipedia.org/wiki/Iconographie_des_corrélations}
}
\details{
plot.IconoCorel checks and corrects the dataframe to be used with IC_threshold_matrix
}
\examples{
\dontrun{
library("HelpersMG")
es <- matrix(c("e1", "52", "12", "12", "5",
"e2", "59", "12.5", "9", "5",
"e3", "55", "13", "15", "9",
"e4", "58", "14.5", "5", "5",
"e5", "66", "15.5", "11", "13.5",
"e6", "62", "16", "15", "18",
"e7", "63", "17", "12", "18",
"e8", "69", "18", "9", "18"), ncol=5, byrow = TRUE)
colnames(es) <- c("Élève", "Poids", "Âge", "Assiduité", "Note")
es <- as.data.frame(es, stringsasFactor=FALSE)
es[, 2] <- as.numeric(as.character(es[, 2]))
es[, 3] <- as.numeric(as.character(es[, 3]))
es[, 4] <- as.numeric(as.character(es[, 4]))
es[, 5] <- as.numeric(as.character(es[, 5]))

es

df <- IC_clean_data(es, debug = TRUE)
cor_matrix <- IC_threshold_matrix(data=df, threshold = NULL, progress=FALSE)
cor_threshold <- IC_threshold_matrix(data=df, threshold = 0.3)
par(mar=c(1,1,1,1))
set.seed(4)
library("igraph")
library("visNetwork")
kk <- plot(cor_threshold, vertex.color="red")
# it can be shown also with the visNetwork package
visIgraph(kk)
cor_threshold_Note <- IC_correlation_simplify(matrix=cor_threshold, variable="Note")
plot(cor_threshold_Note)
}
}
\references{
Lesty, M., 1999. Une nouvelle approche dans le choix des régresseurs de la régression multiple en présence d’interactions et de colinéarités. Revue de Modulad 22, 41-77.
}
\seealso{
Other Iconography of correlations: \code{\link{IC_clean_data}},
  \code{\link{IC_correlation_simplify}},
  \code{\link{IC_threshold_matrix}}
}
\author{
Marc Girondot
}
\concept{Iconography of correlations}
