% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_PlotAnnualRegime.R
\name{PlotAnnualRegime}
\alias{PlotAnnualRegime}
\title{Plot annual regimes}
\usage{
PlotAnnualRegime(
  x,
  line = c("mean", "median"),
  band = c("none", "p05p95", "p25p75", "minmax"),
  add.legend = FALSE,
  l.legend = NULL,
  l.position = c("topright", "bottomright", "right", "topleft", "left", "bottomleft"),
  log = FALSE,
  ylim = NULL,
  ylab = expression(paste("Q (m"^3, " s"^{
     -1
 }, ")")),
  xlab = paste(format(attr(x, "period"), format = "\%Y"), collapse = " to "),
  col = "blue",
  alpha = 30,
  lty = 1,
  lwd = 1,
  mar = c(3, 3, 1, 1) + 0.1,
  verbose = TRUE
)
}
\arguments{
\item{x}{List, typically a result from \code{\link{AnnualRegime}}, containing data frames with aggregated long-term average
regime data and two attributes \code{period} and \code{timestep}.
See Details and Value sections there.}

\item{line}{Character string, keyword for type of average line to plot. Either \code{"mean"} or \code{"median"}.}

\item{band}{Character vector, keyword for variation bands. If \code{"none"} (default), plot average line(s) only. \code{"minmax"},
\code{"p25p75"}, or \code{p5p95} to include bands of variation. Combinations of bands are allowed, but providing \code{"none"}
will always prevent plotting of any band. See details.}

\item{add.legend}{Logical. If \code{TRUE}, a legend will be added to the plot.}

\item{l.legend}{Character vector. If non-NULL, legend labels are read from here instead of from column names in \code{x$mean}.}

\item{l.position}{Legend position, keyword string. One of \code{"left"}, \code{"topleft"}, \code{"topright"},
\code{"right"}, \code{"bottomright"}, \code{"bottomleft"}.}

\item{log}{Logical, if \code{TRUE}, y-axis will be log-scaled.}

\item{ylim}{Numeric vector of length two, giving y-axis limits. Defaults to min-max range of all plotted data.}

\item{ylab}{Character or \code{\link{plotmath}} expression string. Y-axis label, with a default for discharge regimes.}

\item{xlab}{Character string or \code{\link{plotmath}} expression string, x-axis label. Default prints the time period on which the
regime is based, read from \code{x$period}.}

\item{col}{Line color specification, see \code{\link{par}} for details. Defaults to blue. Either a single value or a vector of the same length as quantile
series in \code{freq}.}

\item{alpha}{Numeric, alpha transparency value for variation bands. Value between \code{0} (transparent) and \code{255} (opaque), see
also \code{\link{rgb}}}

\item{lty}{Line type specification, see \code{\link{par}} for details. Either a single value or a vector of the same length as quantile
series in \code{freq}.}

\item{lwd}{Line width specification, see \code{\link{par}} for details. Either a single value or a vector of the same length as quantile
series in \code{freq}.}

\item{mar}{Numeric vector of length 4, margin specification as in \code{\link{par}} with modified default. Details see there.}

\item{verbose}{Logical, print warnings if \code{NA} values are found in \code{x}. Defaults to \code{TRUE}.}
}
\value{
\code{PlotAnnualRegime} returns a plot to the currently active plot device.
}
\description{
Convenience wrapper function for a combined line \code{\link{plot}} with \code{\link{polygon}} variation ranges.
}
\details{
\code{PlotAnnualRegime} plots contents from lists as returned by \code{\link{AnnualRegime}} (for format details, see there). If
\code{NA} values are present in the plot data, the function will throw a warning if \code{verbose = TRUE} and proceed with plotting
all available data.

Argument \code{band} allows to plot variation bands to be plotted in addition to average lines. These can be (combinations of) ranges
between minima and maxima, 5th and 95th percentiles, and 25th and 75th percentiles, i.e. all moments available in \code{AnnualRegime}
results.

Grid lines plotted in the background are mid-month lines.
}
\examples{
\dontrun{
# Source data, HYPE basin output with a number of result variables
te1 <- ReadBasinOutput(filename = system.file("demo_model",
                                              "results", "0003587.txt",
                                              package = "HYPEtools"))
# Daily discharge regime, computed and observed,
# hydrological year from October, aggregated to weekly means
te2 <- AnnualRegime(te1[, c("DATE", "COUT", "ROUT")],
                    ts.in = "day",
                    ts.out = "week", start.mon = 10)
                    
# Screen devices should not be used in examples
PlotAnnualRegime(x = te2)
PlotAnnualRegime(x = te2, line = "median", band = "p05p95",
  add.legend = TRUE, col = c("red", "blue"))
}

}
\seealso{
\code{\link{AnnualRegime}}, \code{\link{PlotSimObsRegime}}
}
