% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BD_ordinations.R
\name{SIP_betaDiv_ord}
\alias{SIP_betaDiv_ord}
\title{Calculating & plotting beta diversity for a list of phyloseq objects}
\usage{
SIP_betaDiv_ord(physeq_l, method = "unifrac", weighted = TRUE,
  fast = TRUE, normalized = TRUE, parallel = FALSE, plot = FALSE)
}
\arguments{
\item{physeq_l}{A list of phyloseq objects}

\item{method}{See phyloseq::distance}

\item{weighted}{Weighted Unifrac (if calculating Unifrac)}

\item{fast}{Fast calculation method}

\item{normalized}{Normalized abundances}

\item{parallel}{Calculate in parallel}

\item{plot}{Return a plot (instead of a data.frame of ordination data)}
}
\value{
If plot==FALSE, a data.frame object of beta-diversity values.
If plot==TRUE, a glob object for plotting.
}
\description{
For each phyloseq object in a list, calculates beta-diversity
between all samples using the phyloseq::distance function.
}
\examples{
data(physeq_S2D2_l)
\dontrun{
physeq_S2D2_l_df = SIP_betaDiv_ord(physeq_S2D2_l)
head(physeq_S2D2_l_df, n=3)
}

}
