/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JPanel;
import ptolemy.gui.ComponentDialog;
import ptolemy.gui.Query;
import ptolemy.gui.QueryListener;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotPoint;

public class PlotFormatter
extends JPanel {
    protected final PlotBox _plot;
    private Query _wideQuery;
    private Query _narrowQuery;
    private String _originalTitle;
    private String _originalXLabel;
    private String _originalYLabel;
    private String _originalMarks;
    private String _originalXTicksSpec;
    private String _originalYTicksSpec;
    private double[] _originalXRange;
    private double[] _originalYRange;
    private Vector[] _originalXTicks;
    private Vector[] _originalYTicks;
    private boolean _originalGrid;
    private boolean _originalStems;
    private boolean _originalColor;
    private boolean[][] _originalConnected;
    private PlotPoint[][] _originalPoints;

    public PlotFormatter(PlotBox plot) {
        int i;
        Vector labels;
        Vector positions;
        StringBuffer buffer;
        this._plot = plot;
        this.setLayout(new BorderLayout());
        this._wideQuery = new Query();
        this.add((Component)this._wideQuery, "West");
        this._narrowQuery = new Query();
        this.add((Component)this._narrowQuery, "East");
        this._wideQuery.setTextWidth(20);
        this._originalTitle = plot.getTitle();
        this._wideQuery.addLine("title", "Title", this._originalTitle);
        this._originalXLabel = plot.getXLabel();
        this._wideQuery.addLine("xlabel", "X Label", this._originalXLabel);
        this._originalYLabel = plot.getYLabel();
        this._wideQuery.addLine("ylabel", "Y Label", this._originalYLabel);
        this._originalXRange = plot.getXRange();
        this._wideQuery.addLine("xrange", "X Range", "" + this._originalXRange[0] + ", " + this._originalXRange[1]);
        this._originalYRange = plot.getYRange();
        this._wideQuery.addLine("yrange", "Y Range", "" + this._originalYRange[0] + ", " + this._originalYRange[1]);
        String[] marks = new String[]{"none", "points", "dots", "various", "pixels"};
        this._originalMarks = "none";
        if (plot instanceof Plot) {
            this._originalMarks = ((Plot)plot).getMarksStyle();
            this._wideQuery.addRadioButtons("marks", "Marks", marks, this._originalMarks);
        }
        this._originalXTicks = plot.getXTicks();
        this._originalXTicksSpec = "";
        if (this._originalXTicks != null) {
            buffer = new StringBuffer();
            positions = this._originalXTicks[0];
            labels = this._originalXTicks[1];
            i = 0;
            while (i < labels.size()) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append(labels.elementAt(i).toString());
                buffer.append(" ");
                buffer.append(positions.elementAt(i).toString());
                ++i;
            }
            this._originalXTicksSpec = buffer.toString();
        }
        this._wideQuery.addLine("xticks", "X Ticks", this._originalXTicksSpec);
        this._originalYTicks = plot.getYTicks();
        this._originalYTicksSpec = "";
        if (this._originalYTicks != null) {
            buffer = new StringBuffer();
            positions = this._originalYTicks[0];
            labels = this._originalYTicks[1];
            i = 0;
            while (i < labels.size()) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append(labels.elementAt(i).toString());
                buffer.append(" ");
                buffer.append(positions.elementAt(i).toString());
                ++i;
            }
            this._originalYTicksSpec = buffer.toString();
        }
        this._wideQuery.addLine("yticks", "Y Ticks", this._originalYTicksSpec);
        this._originalGrid = plot.getGrid();
        this._narrowQuery.addCheckBox("grid", "Grid", this._originalGrid);
        this._originalStems = false;
        this._originalConnected = null;
        if (plot instanceof Plot) {
            this._originalStems = ((Plot)plot).getImpulses();
            this._narrowQuery.addCheckBox("stems", "Stems", this._originalStems);
            this._saveConnected();
            this._narrowQuery.addCheckBox("connected", "Connect", ((Plot)plot).getConnected());
        }
        this._originalColor = plot.getColor();
        this._narrowQuery.addCheckBox("color", "Use Color", this._originalColor);
        this._wideQuery.addQueryListener(new QueryListener(){

            public void changed(String name) {
                if (name.equals("title")) {
                    PlotFormatter.this._plot.setTitle(PlotFormatter.this._wideQuery.getStringValue("title"));
                } else if (name.equals("xlabel")) {
                    PlotFormatter.this._plot.setXLabel(PlotFormatter.this._wideQuery.getStringValue("xlabel"));
                } else if (name.equals("ylabel")) {
                    PlotFormatter.this._plot.setYLabel(PlotFormatter.this._wideQuery.getStringValue("ylabel"));
                } else if (name.equals("xrange")) {
                    PlotFormatter.this._plot.read("XRange: " + PlotFormatter.this._wideQuery.getStringValue("xrange"));
                } else if (name.equals("xticks")) {
                    String spec = PlotFormatter.this._wideQuery.getStringValue("xticks").trim();
                    PlotFormatter.this._plot.read("XTicks: " + spec);
                } else if (name.equals("yticks")) {
                    String spec = PlotFormatter.this._wideQuery.getStringValue("yticks").trim();
                    PlotFormatter.this._plot.read("YTicks: " + spec);
                } else if (name.equals("yrange")) {
                    PlotFormatter.this._plot.read("YRange: " + PlotFormatter.this._wideQuery.getStringValue("yrange"));
                } else if (name.equals("marks")) {
                    ((Plot)PlotFormatter.this._plot).setMarksStyle(PlotFormatter.this._wideQuery.getStringValue("marks"));
                }
                PlotFormatter.this._plot.repaint();
            }
        });
        this._narrowQuery.addQueryListener(new QueryListener(){

            public void changed(String name) {
                if (name.equals("grid")) {
                    PlotFormatter.this._plot.setGrid(PlotFormatter.this._narrowQuery.getBooleanValue("grid"));
                } else if (name.equals("stems")) {
                    ((Plot)PlotFormatter.this._plot).setImpulses(PlotFormatter.this._narrowQuery.getBooleanValue("stems"));
                    PlotFormatter.this._plot.repaint();
                } else if (name.equals("color")) {
                    PlotFormatter.this._plot.setColor(PlotFormatter.this._narrowQuery.getBooleanValue("color"));
                } else if (name.equals("connected")) {
                    PlotFormatter.this._setConnected(PlotFormatter.this._narrowQuery.getBooleanValue("connected"));
                }
                PlotFormatter.this._plot.repaint();
            }
        });
    }

    public void apply() {
        this._plot.setTitle(this._wideQuery.getStringValue("title"));
        this._plot.setXLabel(this._wideQuery.getStringValue("xlabel"));
        this._plot.setYLabel(this._wideQuery.getStringValue("ylabel"));
        this._plot.read("XRange: " + this._wideQuery.getStringValue("xrange"));
        this._plot.read("YRange: " + this._wideQuery.getStringValue("yrange"));
        this._plot.setGrid(this._narrowQuery.getBooleanValue("grid"));
        this._plot.setColor(this._narrowQuery.getBooleanValue("color"));
        if (this._plot instanceof Plot) {
            Plot cplot = (Plot)this._plot;
            cplot.setMarksStyle(this._wideQuery.getStringValue("marks"));
            cplot.setImpulses(this._narrowQuery.getBooleanValue("stems"));
            this._setConnected(this._narrowQuery.getBooleanValue("connected"));
        }
        this._plot.repaint();
    }

    public void openModal() {
        ComponentDialog dialog;
        String[] buttons = new String[]{"Apply", "Cancel"};
        Container toplevel = this._plot.getTopLevelAncestor();
        Frame frame = null;
        if (toplevel instanceof Frame) {
            frame = (Frame)toplevel;
        }
        if ((dialog = new ComponentDialog(frame, "Set plot format", this, buttons)).buttonPressed().equals("Apply")) {
            this.apply();
        } else {
            this.restore();
        }
    }

    public void restore() {
        this._plot.setTitle(this._originalTitle);
        this._plot.setXLabel(this._originalXLabel);
        this._plot.setYLabel(this._originalYLabel);
        this._plot.setXRange(this._originalXRange[0], this._originalXRange[1]);
        this._plot.setYRange(this._originalYRange[0], this._originalYRange[1]);
        this._plot.setGrid(this._originalGrid);
        this._plot.setColor(this._originalColor);
        if (this._plot instanceof Plot) {
            Plot cplot = (Plot)this._plot;
            cplot.setMarksStyle(this._originalMarks);
            cplot.setImpulses(this._originalStems);
            this._restoreConnected();
        }
        this._plot.repaint();
    }

    private void _saveConnected() {
        Vector points = ((Plot)this._plot)._points;
        this._originalConnected = new boolean[points.size()][];
        this._originalPoints = new PlotPoint[points.size()][];
        int dataset = 0;
        while (dataset < points.size()) {
            Vector pts = (Vector)points.elementAt(dataset);
            this._originalConnected[dataset] = new boolean[pts.size()];
            this._originalPoints[dataset] = new PlotPoint[pts.size()];
            int i = 0;
            while (i < pts.size()) {
                PlotPoint pt = (PlotPoint)pts.elementAt(i);
                this._originalConnected[dataset][i] = pt.connected;
                this._originalPoints[dataset][i] = pt;
                ++i;
            }
            ++dataset;
        }
    }

    private void _setConnected(boolean value) {
        Vector points = ((Plot)this._plot)._points;
        ((Plot)this._plot).setConnected(value);
        boolean[][] result = new boolean[points.size()][];
        int dataset = 0;
        while (dataset < points.size()) {
            Vector pts = (Vector)points.elementAt(dataset);
            result[dataset] = new boolean[pts.size()];
            boolean first = true;
            int i = 0;
            while (i < pts.size()) {
                PlotPoint pt = (PlotPoint)pts.elementAt(i);
                pt.connected = value && !first;
                first = false;
                ++i;
            }
            ++dataset;
        }
    }

    private void _restoreConnected() {
        int dataset = 0;
        while (dataset < this._originalPoints.length) {
            int i = 0;
            while (i < this._originalPoints[dataset].length) {
                PlotPoint pt = this._originalPoints[dataset][i];
                pt.connected = this._originalConnected[dataset][i];
                ++i;
            }
            ++dataset;
        }
    }
}

