\name{HSAR-package}
\alias{HSAR-package}
\alias{HSAR}
\docType{package}
\title{
Hierarchical Spatial Autoregressive Model 
}
\description{
Implements a Hierarchical Spatial Simultaneous Autoregressive Model (HSAR) or a multi-scale spatial econometrics model, with inference in a Bayesian setting using Markov chain Monte Carlo (MCMC) simulation. The appraoch is developed for modelling geographic data with a hierarchical/nested structure, for example, houses nesting into districts or fine-grained spatial units into more aggregated units. The HSAR model brings together the spatial econometrics and multilevel models and thus suitable for a simultaneous capturing the potential spatial dependence (autocorrelations) at each level of the data hierarchy arising from geographical proximity effect and the contextual effect (or group dependence effect) from higher-level units upon lower-level units. The creation of this package was supported by the Economic and Social Research Council (ESRC) through the Applied Quantitative Methods Network: Phase II, grant number ES/K006460/1.}
\details{
\tabular{ll}{
Package: \tab HSAR\cr
Type: \tab Package\cr
Version: \tab 0.5\cr
Date: \tab 2020-6-1\cr
License: \tab GPL (>= 2)
}

}

\author{
Guanpeng Dong, Richard Harris, Angelos Mimis
\email{ <mimis@panteion.gr>}
}

\references{
Anselin, L. (1988). \emph{Spatial Econometrics: Methods and Models}. Dordrecht: Kluwer Academic Publishers.


Goldstein, H. (2003). \emph{Multilevel Statistical Methods, 3rd ed}. London: Arnold.


LeSage, J. P., and R. K. Pace. (2009). \emph{Introduction to Spatial Econometrics}. Boca Raton, FL: CRC Press/Taylor & Francis


Dong, G. and Harris, R. 2015. Spatial Autoregressive Models for Geographically Hierarchical Data Structures. \emph{Geographical Analysis}, 47:173-191. }

\keyword{ spatial econometrics }
