% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRD.r
\name{plotRD}
\alias{plotRD}
\title{Plot RD results}
\usage{
plotRD(distr, track, ptt, known = NULL, g, xlims, ylims, makePlot = TRUE,
  save.plot = FALSE)
}
\arguments{
\item{distr}{is output array from \code{hmm.smoother}}

\item{track}{is output dataframe from \code{calc.track}}

\item{ptt}{is individual identification number}

\item{known}{is 3 column data frame containing date, lat, lon of known
movement track. This is only useful for comparing HMMoce results to known
track collected by SPOT or GPS, for example. Default is NULL.}

\item{g}{grid from \code{\link{setup.grid}}}

\item{xlims}{a vector of length 2 indicating longitude limits (-180 to 180).}

\item{ylims}{a vector of length 2 indicating latitude limits}

\item{makePlot}{is logical indicating whether to make a plot of the RD}

\item{save.plot}{is logical indicating whether you want the plot written to
disk using \code{pdf}.}
}
\value{
a list of one raster layer for the combined RD and one raster brick (2 layers) for the individual behavior RDs.
}
\description{
\code{plotRD} uses HMM output via \code{calc.track} to calculate and plot residency distributions for each behavior state and combined data
}
