% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.env.r
\name{get.env}
\alias{get.env}
\title{Download and Read Oceanographic Data}
\usage{
get.env(uniqueDates = NULL, filename = NULL, type = NULL,
  spatLim = NULL, resol = NULL, save.dir = getwd(), sst.type = NULL,
  depLevels = NULL)
}
\arguments{
\item{uniqueDates}{is a POSIXct vector of desired dates}

\item{filename}{is first part of the filename specified to the download 
function. For example, if downloaded files were specific to a particular 
dataset, you may want to identify that with a name like 'tuna' or 'shark1'.
This results in a downloaded filename of, for example, 'tuna_date.nc'.}

\item{type}{is a character string indicating whether you're after sea surface
temperature 'sst', hybrid coordinate ocean model 'hycom', or world ocean 
atlas 'woa' data}

\item{spatLim}{is a list of spatial limits as \code{list(xmin, xmax, ymin, 
ymax)}}

\item{resol}{is character describing the desired resolution in degrees if 
type = 'woa', otherwise NULL. Choices are 'one' or 'quarter'.}

\item{save.dir}{is the directory to save the downloaded data to}

\item{sst.type}{is character indicating type of desired SST product. Choices 
are currently Optimum Interpolation ('oi')
\url{https://www.ncdc.noaa.gov/oisst} or a high-resolution composite
('ghr') \url{https://www.ghrsst.org/}.}

\item{depLevels}{is an integer describing which depth levels to download from
Hycom (e.g. 1=surface). Default is NULL and all levels are downloaded.}
}
\value{
nothing, just downloads the data to your local machine
}
\description{
\code{get.env} accesses oceanographic data like sea surface temperature from 
a remote server and downloads the temporal and spatial extent of interest for
further use
}
\examples{
\dontrun{
# Not run to prevent actual data download
sp.lim <- list(lonmin = -82, lonmax = -25, latmin = 15, latmax = 50)
# FOR OI SST DATA
get.env(as.Date('2015-10-01'), filename='oisst', type = 'sst', 
sst.type='oi', spatLim = sp.lim, save.dir = tempdir())

# FOR HYCOM DATA
get.env(as.Date('2015-10-01'), filename='hycom', type = 'hycom', 
spatLim = sp.lim, save.dir = tempdir())

# FOR WORLD OCEAN ATLAS DATA
get.env(type = 'woa', resol = 'quarter', save.dir = woa.dir)
}
}
