% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.utility.R
\name{build.consistent.graph}
\alias{build.consistent.graph}
\title{Build Consistent Graph}
\usage{
build.consistent.graph(g = g, root = "00")
}
\arguments{
\item{g}{an object of class \code{graphNEL}.}

\item{root}{name of the class that is on the top-level of the hierarchy (\code{def. root="00"}).}
}
\value{
a graph (as an object of class \code{graphNEL}) in which all nodes are accessible from root.
}
\description{
build a graph in which all nodes are reachable from root.
}
\details{
all nodes not accessible from the root (if any) are removed from the graph and printed on stdout.
}
\examples{
data(graph);
root <- root.node(g);
G <- graph::addNode(c("X","Y","Z"), g);
G <- graph::addEdge(c("X","Y","Z"), c("HP:0011844","HP:0009810","HP:0012385"), G);
G <- build.consistent.graph(G, root=root);
}
