% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmmvbBIC.R
\name{hmmvbBIC}
\alias{hmmvbBIC}
\title{BIC for HMM-VB}
\usage{
hmmvbBIC(data, VbStructure, configList = NULL, numst = 1:10,
  trControl = trainControl(), nthread = 1)
}
\arguments{
\item{data}{A numeric vector, matrix, or data frame of observations.
Categorical values are not allowed. If a matrix or data frame, rows 
correspond to observations and columns correspond to variables.}

\item{VbStructure}{An object of class 'VB'. Variable block 
structure stored in VbStructure is used to train HMM-VB model. \code{numst} parameter
of the variable block structure is ignored.}

\item{configList}{A list of integer vectors specifying number of states in each variable
block for which BIC is to be calculated.}

\item{numst}{An integer vector specifying the numbers of mixture components (states) in 
each variable block for which BIC is to be calculated. Number of states is the same for 
all variable blocks. The argument is ignored if \code{configList} argument is provided.}

\item{trControl}{A list of control parameters for HMM-VB training algorithm.
The defaults are set by the call \code{hmmvbTrainControl()}.}

\item{nthread}{An integer specifying the number of threads used in searching and 
training routines.}
}
\value{
A named list with estimated BIC values and the number of states or state configurations
for which BIC was calculated.
}
\description{
This function finds an optimal number of mixture components (states) for 
HMM-VB using the Bayesian Information Criterion (BIC). The variable block 
structure is provided as input and then BIC is estimated for HMM-VB with 
different configurations of states for the variable blocks.
}
\examples{
\donttest{
# Default search for the optimal number of states for HMM-VB model 
data("sim3")
Vb <- vb(2, dim=40, bdim=c(10,30), numst=c(1,1), varorder=list(c(1:10),c(11:40)))
set.seed(12345)
hmmvbBIC(sim3[1:40], VbStructure)

# Search for the optimal number of states for HMM-VB model using 
# provided values for the number of states 
data("sim3")
Vb <- vb(2, dim=40, bdim=c(10,30), numst=c(1,1), varorder=list(c(1:10),c(11:40)))
set.seed(12345)
hmmvbBIC(sim3[1:40], VbStructure=Vb, numst=c(2L, 4L, 6L))

# Search for the optimal number of states for HMM-VB model using 
# provided configurations of the number of states 
data("sim3")
Vb <- vb(2, dim=40, bdim=c(10,30), numst=c(1,1), varorder=list(c(1:10),c(11:40)))
set.seed(12345)
configs = list(c(1,2), c(3,5), c(6,7))
hmmvbBIC(sim3[1:40], VbStructure=Vb, configList=configs)}
}
\seealso{
\code{\link{VB}}, \code{\link{vb}}, \code{\link{trainControl}}
}
