% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robot_plot_All.R
\name{robot_plot_All}
\alias{robot_plot_All}
\title{Returns a robot plot for comparisons of the timepoints samples}
\usage{
robot_plot_All(
  thP,
  th,
  replicates = 3,
  pv_cutoff = 0.01,
  states,
  CI_factor = 1
)
}
\arguments{
\item{thP}{output of output_tcourse_proc() function. Raw data for procent deuteration for time courses}

\item{th}{output of output_tcourse() function. Raw data for uptake deuteration for time courses}

\item{replicates}{number of replicates in sample. Default set to 3.}

\item{pv_cutoff}{p-value cutoff here set up to 0.01}

\item{states}{Protein states from the set. As default all states are chosen.}

\item{CI_factor}{Multiplication factor for Critical Interval. Allows for more restrictive selection of Critial interval.}
}
\value{
Robot maps for timecourses
}
\description{
Modification of butterfly plot. x axis residues.
y axis \% deuteration for one variant above the axis and for second peptide below the axis.
Peptides are compared between the sets for the significance change between sets.
If there is significant change beteween sets peptides are plotted for all timepoints.
Significanty different timepoints for the peptides are colored.
Peptides ranges are plotted as a line at corresponding \% deuteration values.
}
\examples{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
tm_df<-output_tc(filepath=file_nm)
tmP_df<-output_tc(filepath=file_nm, percent=TRUE)
robot_plot_All(thP = tmP_df, th=tm_df, pv_cutoff=0.001)

# more restrictive peptide selection
robot_plot_All(thP = tmP_df, th=tm_df, pv_cutoff=0.001, CI_factor=3)

}
