% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pymol_str_significant_residue.R
\name{pymol_script_significant_residue}
\alias{pymol_script_significant_residue}
\title{Writes a text files with pymol scripts to list significant residues.}
\usage{
pymol_script_significant_residue(
  df,
  path = "",
  ranges = c(-Inf, seq(-30, 30, by = 10), Inf),
  pv_cutoff = 0.01,
  replicates = 3
)
}
\arguments{
\item{df}{average data frame. Generated using ave_timepoint() function.}

\item{path}{location where the Pymol scripts will be saved}

\item{ranges}{ranges for coloring scheme. Default set to c(-Inf, seq(-30, 30, by=10), Inf)}

\item{pv_cutoff}{p-value cutoff here set up to 0.01}

\item{replicates}{number of replicates in sample. Default set to 3.}
}
\value{
pymol script with colors assigned per residues by maximum uptake per residue
}
\description{
Function write a script that can be used in pymol to color structure.
Number of colors and corresponding to them ranges can be defined by user.
Residues are being colored by maximum uptake from significant peptides per residues.
}
\examples{
\donttest{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a<- output_tp(file_nm)
pymol_script_significant_residue(df=a, path=tempdir(), replicates=3, pv_cutoff=0.01,
ranges=c(-Inf,-40, -30,-20,-10, 0,10, 20,30,40, Inf) )
pymol_script_significant_residue(df=a, path=tempdir())
}
}
