% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mean_shrink.R
\name{mean_bs}
\alias{mean_bs}
\title{Bayes-Stein shrinkage estimator of the mean vector}
\usage{
mean_bs(x)
}
\arguments{
\item{x}{a p by n matrix or a data frame of asset returns. Rows represent
different assets, columns -- observations.}
}
\value{
a numeric vector containing the Bayes-Stein shrinkage estimator
of the mean vector
}
\description{
Bayes-Stein shrinkage estimator of the mean vector as suggested in
\insertCite{Jorion1986;textual}{HDShOP}. The estimator is given by
\deqn{\hat \mu_{BS} = (1-\beta) \bar x + \beta Y_0 1,} where
\eqn{\bar x} is the sample mean vector, \eqn{\beta} and \eqn{Y_0} are
derived using Bayesian approach (see Eq.(14) and Eq.(17) in
\insertCite{Jorion1986;textual}{HDShOP}).
}
\examples{
n <- 7e2 # number of realizations
p <- .5*n # number of assets
x <- matrix(data = rnorm(n*p), nrow = p, ncol = n)
mm <- mean_bs(x=x)
}
\references{
\insertAllCited{}
}
